<?php

use common\models\User;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use common\models\Vote;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use common\components\Globals;
use kartik\date\DatePicker;
use common\helpers\Date;


/* @var $this yii\web\View */
/* @var $model backend\models\UserForm */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $roles yii\rbac\Role[] */
/* @var $permissions yii\rbac\Permission[] */

?>

<div class="col-md-12">

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
    <div class="col-md-6">
        <?php echo $form->field($model, 'username') ?>
    </div>
    <div class="col-md-6">
        <?php echo $form->field($model, 'email') ?>
    </div>
        </div>
    <div class="row">
    <div class="col-md-3">
        <?php echo $form->field($model, 'password')->passwordInput() ?>
    </div>
        <div class="col-md-3">
        
            <?php echo $form->field($model, 'expire')->dropDownList(User::expireoptions()) ?>
    </div>
    <div class="col-md-6">
        <?php echo $form->field($model, 'type')->dropDownList(User::usertypes(),['selected'=>$model->type]) ?>
    </div>
    </div>
    <div class="row">
  
    <div class="col-md-3">
         <?php echo $form->field($model,'initial_date')->hiddenInput(); ?>
    
    <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'initial_date', 	
	'options' => ['placeholder' => 'Select start date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
        ]); ?></div>

    <div class="col-md-3">
        <?php echo $form->field($model,'final_date')->hiddenInput(); ?>
    <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'final_date',
                   
	'options' => ['placeholder' => 'Select end date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true,
            'minDate'=>'0',
	]
          ]); ?> </div>
     <div class="col-md-6">
        
            <?php echo $form->field($model, 'status')->dropDownList(User::statuses()) ?>
    </div>
    </div>
    <div class="row">
     <div class="col-md-6">
        <?php
        
        $votes= Globals::allVotes();
          $listData=ArrayHelper::map($votes,'id','name'); 
        echo $form->field($model, 'votes')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...','multiple'=>true],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
    </div>
   
    <div class="col-md-6">
        <?php echo $form->field($model, 'roles')->checkboxList($roles) ?>
    </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php echo Html::submitButton(Yii::t('backend', 'Save'), ['class' => 'btn btn-primary pull-left', 'name' => 'signup-button']) ?>
        </div>
    </div>
    <?php ActiveForm::end(); ?>

</div>
