<?php

use common\grid\EnumColumn;
use common\models\User;
use yii\helpers\Html;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\search\UserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('backend', 'Users');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-index">

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?php echo Html::a(Yii::t('backend', 'Create {modelClass}', [
    'modelClass' => 'User',
]), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php echo GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'options' => [
            'class' => 'grid-view table-responsive'
        ],
        'columns' => [
           [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
            'first_name',
            'last_name',
            'username',
                 
            
            [
                'class' => EnumColumn::className(),
                'attribute' => 'type',
                'enum' => User::usertypes(),
                'filter' => User::usertypes()
            ],
             [
                'class' => EnumColumn::className(),
                'attribute' => 'status',
                'enum' => User::statuses(),
                'filter' => User::statuses()
            ],
             [
                'header' =>'Votes',
                  'format' => 'raw',
                'value' => function($model) {
                      $expired = $model->expired?"Password: <b style='color:red'>Expired </b>":"";
                    return $expired.'<br/>'.$model->votesvalue;
         },
            ],
            'logged_at:datetime',
            // 'updated_at',

            [
                'class' => 'yii\grid\ActionColumn',
                'template'=>
                '{view}'
                
                ],
            
        ],
    ]); ?>

</div>
