<?php
namespace common\components;

use Yii;
use common\models\FinancialYear;
use common\models\Quarter;
use common\models\UserVote;
use common\models\Vote;
use common\models\ReportingDetail;
use common\models\ReportingUpload;
use common\models\User;

class Globals {
    const  UPLOAD_DIR ='/documents/';
    const MESSAGE_TYPE_SUCCESS = 1;
    const  MESSAGE_TYPE_ERROR = 2;


        public static function getFilesUploadPath() {
       
        return self::UPLOAD_DIR ? Yii::app()->params['mainUploadPath'] . self::UPLOAD_DIR : NULL;
    }
    
    /**
         * insert budget details to budget model activity
         * 
         * **/
       
        public static function getYearOptions(){
            $start_year = 2016;
            $end_year = date('Y')+5;
            $years = array();
            for($i=$start_year; $i<=$end_year; $i++):
             $years[] = array('id'=>$i,'name'=>$i);   
            endfor;
            return $years;
        }
           /**
         * Returns exchange rate amount in TZS equivalent to  unit currency amount passed
         * ****/
      
     
        /**
         * returns loaded BudgetActivity model
         * 
         * ***/
        public static function  load_budget_entry($budget_id,$activity_id,$year=null){
            if(!$year)
                $year = Globals::getCurrentYear();
            $model = BudgetActivity::model()->findByAttributes(array('year'=>$year,'budget_id'=>$budget_id,'activity_no'=>$activity_id));
            if($model) return $model;
            return false;
            
        }
        /**
         * returns sum of paid amount for specific activity
         * 
         * ***/
     
     public static function format_string_to_number($number_string){
         return str_replace(",", "", $number_string);
     }
 

    public static function display_money($amount,$format=2){
        $r_amount ="<b>-</b>";
        if($amount>0)
            $r_amount = number_format ($amount,$format);
        return $r_amount;
            
    }
 
     public static function getYesNoOptions(){
        return array(
            array('id'=>0,'name'=>'No'),
            array('id'=>1,'name'=>'Yes'),
            
            );
    }
     
    /**
     * delete directory
     * **/
   public static  function deleteDirectory($dir) {
    if (!file_exists($dir)) {
        return true;
    }

    if (!is_dir($dir)) {
        return unlink($dir);
    }

    foreach (scandir($dir) as $item) {
        if ($item == '.' || $item == '..') {
            continue;
        }

        if (!deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
            return false;
        }

    }

    return rmdir($dir);
}
public static function cleanStringMoney($a) {
    return  preg_replace('/[^0-9^\.]/', '', $a);

}
/******
 * Get union display name
 * *****/
   /**
     * returns temporary user files uploads path
     * ****/
    public static function getTempFilesUploadPath() {
         //set user temp upload path
        $user_id = Yii::app()->user->id;
        $user_temp_upload_path = self::getFilesUploadPath() . "tmp/user" . $user_id . "/";
        if (!file_exists($user_temp_upload_path)) {
            mkdir($user_temp_upload_path, 0777, true);
        }
      return $user_temp_upload_path;
    }
     /**
     * 
     * @return String main upload file for student files upload/loads/files
     */
    public static function getFilesUploadUrl() {
     
        return self::UPLOAD_DIR ? Yii::app()->getBaseUrl('true') . Globals::param('mainUploadUrl') . self::UPLOAD_DIR : NULL;
    }
 
    
    /**
     * Send email
     * @param string $from_email Email From
     * @param string $from_name Name of Sender
     * @param string $to_email   Recipient Email
     * @param string  $subject Email Subject
     * @param string $message Email Body Message
     * @param Array $cc_email  CC Recipient Email 
     * @param Array $files Array of attachments e.g  array(array('name'=>'first file','url'=>'http://link.com/files/file1.pdf'),array('name'=>'first file','url'=>'http://link.com/files/file1.pdf'))
     * ***/
    public static function sendEmail($from_email,$from_name,$to_email,$subject,$message,
            $cc_email, $files = array()) {
       $return = false;
        $mail = new YiiMailer();
        $mail->setView('default');
   $mail->setFrom($from_email, $from_name);
        $mail->setTo($to_email);
        if($cc_email){
        
        $mail->setCc($cc_email);
        }
        $mail->setSubject($subject);
        $mail->setData(array('body' => $message, 'files' => $files));
        //set smtp
        $host = Yii::app()->params['Host'];
        $port = Yii::app()->params['Port'];
        $SMTPSecure = Yii::app()->params['SMTPSecure'];
        $SMTPAuth = Yii::app()->params['SMTPAuth'];
        $Username = Yii::app()->params['Username'];
	$Password = Yii::app()->params['Password'];
	
        $mail->setSmtp($host, $port, $SMTPSecure, $SMTPAuth, $Username, $Password);
        if ($mail->send()){
              $mail->copyToFolder("Sent"); // Will save into Sent folder
            $return = true;
        }
           
           return $return;
        
    }
    /**
     * Unformat number to normal number example 6,680 to 6680
     * **/
    public static function unformat_number($number){
        if ( strstr( $number, ',' ) ) $number = str_replace( ',', '', $number );
        return $number;
    }
    /***
     * Get human readable filesize
     * **/
    public static  function human_filesize($bytes, $decimals = 2) {
  $sz = 'BKMGTP';
  $factor = floor((strlen($bytes) - 1) / 3);
  return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
}
    /**
     * Get number of loads in each week
     * @param Load $loads Load Models
     * @return array Array of weeks 1-5 of month will counts of loads in each week
     * ***/
    public static function weekscount($loads){
             $w1count=0; $w2count=0; $w3count=0; $w4count=0; $w5count=0;
           $weekarray = array();
            foreach($loads as $load):
             //initialize week state
            $loopweek = Globals::getWeekNo(date('Y-m-d', $load->entry_date), 'Monday');
            //if($loopweek == 2) echo $w2count++; exit;
             switch ($loopweek) {
                 case 1: ++$w1count; 
                     break;
                 case 2: ++$w2count;
                     break;
                 case 3: ++$w3count;
                     break;
                 case 4: ++$w4count;
                     break;
                 case 5: ++$w5count; 
                     break;
                default:
                     break;
             }
          
          endforeach;
          //echo $w2count; exit;
          $weekarray[] = array('week'=>1,'count'=>$w1count);
          $weekarray[] = array('week'=>2,'count'=>$w2count);
           $weekarray[] = array('week'=>3,'count'=>$w3count);
          $weekarray[] = array('week'=>4,'count'=>$w4count);
           $weekarray[] = array('week'=>5,'count'=>$w5count);
        
          return $weekarray;
         
         }
    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over default=sunday
     */
  public static  function getWeekNo($date, $rollover="Sunday")
    {
        $cut = substr($date, 0, 8);
        $daylen = 86400;

        $timestamp = strtotime($date);
        $first = strtotime($cut . "00");
        $elapsed = ($timestamp - $first) / $daylen;

        $weeks = 1;

        for ($i = 1; $i <= $elapsed; $i++)
        {
            $dayfind = $cut . (strlen($i) < 2 ? '0' . $i : $i);
            $daytimestamp = strtotime($dayfind);

            $day = strtolower(date("l", $daytimestamp));

            if($day == strtolower($rollover))  $weeks ++;
        }

        return $weeks;
    }
/**
 * get url for temporary folder  
 * @return string url
 */
function getTempFolder() {
    return param('mainUploadPath') . '/temp';
}

/**
 * get absolute path for general attachment 
 * @return string url
 */
function getAttachmentFolder() {
    return param('mainUploadPath') . '/attachments';
}

/**
 * get url for general attachment 
 * @return string url
 */
function getAttachmentUrl() {
    return getPublicUploadUrl() . '/attachments';
}

/**
 * return upload folder url
 * @return string url
 */
function getPublicUploadUrl() {
    return baseUrl() . param('mainUploadUrl');
}



/**
 * 
 * @param type $fname
 * @param type $lname
 * @return type string formated name
 */
function format_name($fname, $lname) {
    return $fname . ' ' . strtoupper(substr($lname, 0, 1)) . '.';
}



/**
 * 
 * @param type $user_id
 * @param type $len
 * @return type
 */
function generate_uuid($user_id) {
    //get max leng of the account code   
    $len = Yii::app()->params['accountCodeLength'];
    $hex = md5($user_id . uniqid("", true));

    $pack = pack('H*', $hex);
    $tmp = base64_encode($pack);

    $uid = preg_replace("#(*UTF8)[^A-HJ-NP-Z2-9]#", "", $tmp);
    //remove consecutive repeating characters
    $uid = preg_replace('/(.)\\1+/', '$1', $uid);
    $len = max(4, min(128, $len));

    while (strlen($uid) < $len)
        $uid .= generate_uuid($user_id, 22);

    return substr($uid, 0, $len);
}

/**
 * Accepts string, return alpha-numeric charcters 
 * @param type $string
 */
function get_key($string) {
    $key = preg_replace("~[^a-z0-9:]~i", "", $string);
    return strtolower($key);
}

function get_list($model, $label, $value = 'id') {
    if (!$label)
        $label = 'name';
    if (!$value)
        $value = 'id';
    return CHtml::listData($model, $value, $label);
}

function get_unique_filename() {
    return rand(0, 99) . time() . Yii::app()->user->id . rand(0, 999);
}

function url($route, $params = array()) {

    return Yii::app()->createUrl($route, $params);
}

public static function baseUrl() {
    return Yii::app()->baseUrl;
}

/**
 * 
 * @param type array $array
 * @return String separated by commas
 */
function get_string($array) {
    $string = null;
    $i = 0;
    if (is_array($array)) {
        $len = sizeof($array);
        foreach ($array as $elem) {
            $string .= $elem;

            if (++$i < $len)
                $string .= ',';
        }
    }
    return $string;
}


/**
 * 
 * @param type $path
 * @return boolean
 */
function file_download($path, $name = null) {
    $file = Yii::app()->file->set($path, true);

    if ($file->exists)
        $file->download($name);
    else
        return false;

    return true;
}

/**
 * it wraps yii::app()->params[]
 * @param  string $key key of parameter
 * @return string param value
 */
public static function param($key) {
    return Yii::app()->params[$key];
}

/**
 * 
 * @param string $label stat label
 * @param number $value number of the stat
 * @param  boolean $both if both label and value should be returned 
 * @param boolen $plural  if the stat has plural form default true
 * @return string formated label
 */
function format_stats($label, $value, $both = true, $plural = true) {
    if ($value > 1) {
        if ($plural)
            $label = $label . 's';
    }
    if ($both)
        return number_format($value) . ' ' . $label;

    return $label;
}

/**
 * 
 * @param static $model
 * @return static model
 * @throws CHttpException if model is null
 */
function load($model) {
    if (!$model)
        throw new CHttpException(404, 'Page requested not found');
    return $model;
}

public static function format_money($money, $includeCurrency = true) {
    /// $space = '&nbsp;';
    $currency = null;
    if ($includeCurrency)
        $currency = Globals::param('defaultCurrency');

    return $currency . ' ' . number_format($money);
}

/**
 * takes array of data validate them, return array of model object with its validity status
 * It adds a 'prepare' scenerio
 * Array with all elements with null values will be ignored
 * @param type $datas  array of data to be validated and assigned to a model 
 * @param type $additon addition model attributes that was not submitted with form
 * @return array  of models and the boolean validity status
 */
function getDataArray($datas, $modelClass, $additon = array()) {
    $array = array();
    $i = 0;
    $isValid = true;
    foreach ($datas as $data) {
        $model = new $modelClass;
        $model->scenario = 'prepare';
        $model->attributes = $data;
        //addition field that are not form fields
        foreach ($additon as $attribute => $value)
            $model->$attribute = $value;

        $isValid = !$model->validate() ? false : true;

        //pack details into array only if any of the field has value   
        foreach ($data as $key => $value) {
            if (!empty($data[$key])) {
                $array[] = $model;
                break;
            }
        }
    }

    return array('models' => $array, 'isValid' => $isValid);
}

/**
 * Saves array of cactive models to db
 * @param array of CactiveRecord models to be saved
 * @return boolean
 */
function saveArrayOfModel($array) {
    $success = true;
    foreach ($array as $data)
        $success = $data->save() ? true : false;

    return $success;
}

/**
 * get main entity/object label
 * @param type $class
 * @param boolean $plural if it is plural
 * @return string entity model label
 */
function getLabel($class, $plural = false) {
    $attribute = 'm_title';
    if ($plural)
        $attribute = 'm_title_plural';
    $class = ucfirst($class);
    return $class::model()->getAttributeLabel($attribute);
}

/**
 * add date passed 
 * @param DateTime $date
 * @param String $interval 
 * @return string date after addition in the format of @see prefference::getDateFormat()
 */
function addDate($date, $interval) {
    $dateObj = new DateTime($date);
    $dateObj->add(new DateInterval($interval));
    return $dateObj->format(Preference::getDateformat());
}

/**
 * Generate excel2007 sheeet from database
 * @param array $columnTitle attribute title pair array('attributeName1'=>'title1'....)
 * @param array $content content of the excel 
 * @param string $path  path to store the excel
 * @param array $properties 
 * @param boolean $setDownload if true excel will be sent to user browser for download, default true, 
 */
function generateExcel($columnTitle, $content, $path, $properties = array(), $setDownload = true) {
    Yii::import('application.extensions.excel.PHPExcel');
    //statrt column and row
    $startColumn = 'A';
    $startRow = '1';
    //excel format
    $excelFormat = 'Excel5';
    //extension
    $ext = '.xls';
    //default file name
    $defaultFilename = 'download';
    //create file name
    $filename = (isset($properties['filename']) && $properties['filename']) ? $properties['filename'] . $ext : $defaultFilename . $ext;

    $objPHPExcel = new PHPExcel();
    //set document properties
    $prop = $objPHPExcel->getProperties();
    isset($properties['creator']) ? $prop->setCreator($properties['creator']) : null;
    isset($properties['lastModifiedBy']) ? $prop->setLastModifiedBy($properties['lastModifiedBy']) : null;
    isset($properties['title']) ? $prop->setTitle($properties['title']) : null;
    isset($properties['subject']) ? $prop->setSubject($properties['subject']) : null;
    isset($properties['description']) ? $prop->setDescription($properties['description']) : null;
    isset($properties['keywords']) ? $prop->setKeywords($properties['keywords']) : null;
    isset($properties['category']) ? $prop->setCategory($properties['category']) : null;

    //insert data
    $objPHPExcel->setActiveSheetIndex(0);
    $data = $objPHPExcel->getActiveSheet();
    $row = $startRow;
    foreach ($content as $model) {
        //print_r($model); exit;
        $column = $startColumn;
        //add columns title at the first row
        if ($row == $startRow) {
            foreach ($columnTitle as $key => $value) {
                $cell = $column++ . $row;
                $data->setCellValue($cell, $value);
                //set bold
                $data->getStyle($cell)->getFont()->setBold(true);
            }
            ++$row;
            //reset column
            $column = $startColumn;
        }
        //add data
        foreach ($columnTitle as $key => $value) {
            $cell = $column++ . $row;
            if ($key == 'empty')
                continue;
            $data->setCellValue($cell, getCellValue($model, $key));
        }
        ++$row;
    }
    //autofit column
    autoFitColumnWidthToContent($objPHPExcel->getActiveSheet(), 'A', 'B');



    //set worksheetname
    // $objPHPExcel->getActiveSheet()->setTitle('Simple');
// Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $excelFormat);
    $objWriter->save(str_replace(__FILE__, $path . '/' . $filename, __FILE__));

    if ($setDownload)
        Yii::app()->getRequest()->sendFile($filename, file_get_contents($path . '/' . $filename));
}

/**
 * 
 * @param type $model
 * @param string $key 
 * @return string value of the model
 */
function getCellValue($model, $key) {
    $keys = explode('.', $key);

    foreach ($keys as $key)
        $model = $model->{$key};

    return $model;
}

/**
 * resize the columns
 * @param type $sheet
 * @param type $fromCol
 * @param type $toCol
 */
function autoFitColumnWidthToContent($sheet, $fromCol, $toCol) {
    if (empty($toCol)) {//not defined the last column, set it the max one
        $toCol = $sheet->getColumnDimension($sheet->getHighestColumn())->getColumnIndex();
    }
    for ($i = $fromCol; $i !== $toCol; $i++) {
        $calculatedWidth = $sheet->getColumnDimension($i)->getWidth();
        $sheet->getColumnDimension($i)->setWidth((int) $calculatedWidth * 1.05);
    }
    $sheet->calculateColumnWidths();
}

/**
 * 
 * @param string $path path to excel file
 * @param boolean $delete  delete after file read
 * @return array array('columnTitle'=>array(),'data'=>array())
 */
function readExcel($path, $delete = false) {

    Yii::import('application.extensions.excel.PHPExcel');
    new PHPExcel();
    $columnTitle = array();
    $data = array();
    //excel format
    $excelFormat = 'Excel5';
    if (!file_exists($path)) {
        exit("File not found" . EOL);
    }

    $objReader = PHPExcel_IOFactory::createReader($excelFormat);
    $objPHPExcel = $objReader->load($path);
    foreach ($objPHPExcel->getWorksheetIterator() as $worksheet) {

        foreach ($worksheet->getRowIterator() as $row) {
            $rowData = array();
            $cellIterator = $row->getCellIterator();
            $cellIterator->setIterateOnlyExistingCells(false); // Loop all cells, even if it is not set
            foreach ($cellIterator as $cell) {
                //read column titles
                if ($row->getRowIndex() == 1) {
                    $columnTitle[] = $cell->getCalculatedValue();
                    //go to next row after reading a title
                    continue;
                }
                //add data
                $rowData[] = $cell->getCalculatedValue();
            }

            //add row to main
            if ($rowData)
                $data[] = $rowData;
        }
    }
    //delete the file after read
    if ($delete)
        unlink($path);

    return array('columnTitle' => $columnTitle, 'data' => $data);
}

/**
 * 
 * @param type $maxScore
 * @param type $score
 * @return number
 */
function getPercentage($maxScore, $score) {
    return ($score / $maxScore) * 100;
}

/**
 * remove unnecessary zeros 
 * @param type $number
 * @return type
 */
function trimTrailingZeroes($number) {
    return strpos($number, '.') !== false ? rtrim(rtrim($number, '0'), '.') : $number;
}

/**
 * 
 * @param type $role
 * @param type $userId
 * @return type
 */
public static function getDisplayName() {
    $displayname = 'No name';
   if(User::isSuper()){
     $displayname   = Yii::app()->user->username;
   }else{
       $user = User::getUserByUsername(Yii::app()->user->username);
       $displayname = $user?$user->name:'';
   }
   return $displayname;
}
/**
 * 
 * @param type $userId
 * @return type
 */
public static function getDisplayNameById($userId) {
      $user = User::findOne($userId);
      return $user->first_name." ".$user->last_name;
       
}

/**
 * 
 * @param type $class name of a class
 * @param type $attribute 
 * @return string attribute label
 */
function getAttributeLabel($class, $attribute) {
    $class = ucfirst($class);
    return $class::model()->getAttributeLabel($attribute);
}

/**
 * @param type $number number to be deducted
 * @param number $number1 number to deduct from $number
 * @return number the difference between number $number-$number1
 */
function deduct($number, $number1) {
    return $number - $number1;
}

/**
 * @param type $number number to be added
 * @param number $number1 number to be added
 * @return number the summation  $number+$number1
 */
function add($number, $number1) {
    return $number + $number1;
}

/**
 * 
 * @param type $difference
 * @param type $sum
 * @return number percentage
 */
function percentage($difference, $sum) {
    return ($difference / $sum) * 100;
}

/**
 * 
 * @param string $url submit url
 * @param string $btnClass class to be applied to button, default btn btn-default, 
 * @return htmldom button
 */
public static function modalAjaxSubmitButton($label, $url, $btnClass = 'btn btn-primary') {

    return CHtml::ajaxSubmitButton($label, $url, array('update' => '#modal-info',
                'beforeSend' => 'function() { 
                   jQuery(\'body\').undelegate(\'#submit\', \'click\');
                   $("#modal-info").hide();
	           $("#modal .loading").show();  }',
                'success' => 'function(data) {
                       if(data==\'reload_page\') {
                       location.reload(true);
                       }else{
                         $("#modal .loading").hide();
                         $("#modal-info").html(data);
                         $("#modal-info").show();
                       }
	             }'
                    ), array('class' => "$btnClass",
                'id' => 'submit'));
}
/**
 * Returns days left in year
 * @params int $unix_timestamp  unix timestamp
 * @return int Days 
 * ***************/
public static function get_days_left($unix_timestamp){
   
$day_dif = $unix_timestamp - time(); // As the UNIX Timestamp is in seconds, get the seconds you lived
$days = $day_dif / 60 / 60 / 24; // Convert seconds to years
return abs(floor($days)); // Round down to whole integer and echo it
    
}
/**
 * Returns age in year
 * @params int $unix_timestamp  unix timestamp
 * @return int Age in Years
 * ***************/
public static function get_age($unix_timestamp){
   if(!$unix_timestamp) return 0;
$birthday = $unix_timestamp;
$age_dif = time() - $birthday; // As the UNIX Timestamp is in seconds, get the seconds you lived
$age = $age_dif / 60 / 60 / 24 / 365; // Convert seconds to years
return floor($age); // Round down to whole integer and echo it
    
}

/**
 * return timestamp from provided datestring
 * @param type $dateString
 * @param type $format if null, takes the default
 * @return int unix timestamp
 */
public static function get_timeStamp($dateString, $format = null) {
    $format = !$format ? Preference::getDateformat() : $format;
    $date = DateTime::createFromFormat($format, $dateString);
    return $date ? strtotime($date->format(Preference::getDateformat())) : $dateString;
}

/**
 * 
 * @param type $bytes size in bytes
 * @return string file size and unit
 */
function formatSizeUnits($bytes) {
    if ($bytes >= 1073741824) {
        $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        $bytes = number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        $bytes = number_format($bytes / 1024, 2) . ' KB';
    } elseif ($bytes > 1) {
        $bytes = $bytes . ' bytes';
    } elseif ($bytes == 1) {
        $bytes = $bytes . ' byte';
    } else {
        $bytes = '0 bytes';
    }

    return $bytes;
}

function getFontAwsomeIcon($mime_type) {
    $icon = 'file-o';
    if ($mime_type == 'application/pdf')
        $icon = 'file-pdf-o';
    return $icon;
}

/**
 * return extension from a given file mime type
 * uses a file mimeTypeExtension.php that contains array pairing of extension to mime type
 * @param type $mime_type file mime type
 * @return boolean false if extension not found
 */
function getExtensionFromMime($mime_type) {

    $mime_extensions = require(dirname(__FILE__) . '/mimeTypeExtension.php');
    foreach ($mime_extensions as $key => $value) {
        if ($value == $mime_type)
            return $key;
    }

    return false;
}

public static function currentYear(){
    return FinancialYear::findOne(['is_current'=>1]);
}
public static function currentQuarter(){
    return Quarter::findOne(['is_current'=>1]);
}
public static function myVote(){
    $uservote = UserVote::findOne(['user_id'=>Yii::$app->user->id]);
    if($uservote)
    { $vote = Vote::findOne (['id'=>$uservote->vote_id]);  return $vote; }        
    else 
        return null;
}
public static function isMyVote($vote_id){
   
    $vote = self::myVote();
    if($vote){
     return ($vote->id === $vote_id)?true:false;
    }else{
        return false;
    }
}

public static function allVotes(){
    $votes= Vote::find()
             ->where(['directed_to_submit' => Vote::CAN_SUBMIT_INT])
             ->orderBy(['name'=>'ASC'])           
            ->all();
    $votearray=[];
    if($votes)
    {
        foreach ($votes as $vote):
            $votearray[] = ['id'=>$vote->id, 'name'=>$vote->name." - ".$vote->code];
        endforeach;
        
    }
                 return $votearray;
}
/**
 * Checks if the user is Vote user and assigned this Current Vote
 * ***/
public static function inMyVote($vote_model){
    $currentuser_id = Yii::$app->user->id;
    $uservotes = UserVote::findAll(['user_id'=>$currentuser_id]);
  $ismyvote = false;
   $votearray=[];
   //if is admin.
    if(Yii::$app->user->id==1){
     $ismyvote = true;
    }
       
    if($uservotes)
    {
        foreach ($uservotes as $item):
           if(User::isIAOfficer() && ($item->vote_id == $vote_model->id) && ($item->user_id = $currentuser_id))
         $ismyvote = true;
        endforeach;
        
    }
                 return $ismyvote;
}

public static function myVotes(){
    $uservotes = UserVote::findAll(['user_id'=>Yii::$app->user->id]);
  
   $votearray=[];
   //if is admin.
    if(Yii::$app->user->id==1){
     $all = Vote::find()
             ->where(['directed_to_submit' => Vote::CAN_SUBMIT_INT])
             ->all();
     foreach ($all as $vote):
           $votearray[] = ['id'=>$vote->id, 'name'=>$vote->name." - ".$vote->code];
        endforeach;
        return $votearray;
    }
       
    if($uservotes)
    {
        foreach ($uservotes as $item):
          $vote = Vote::findOne($item->vote_id);
            $votearray[] = ['id'=>$vote->id, 'name'=>$vote->name." - ".$vote->code];
        endforeach;
        
    }
                 return $votearray;
}
public static function reportDetail($source,$vote,$year,$quarter=null){
    if($quarter)
        return ReportingDetail::find()
    ->where(['financial_year_id' => $year,'vote_id'=>$vote,'source_id'=>$source,'quarter_id'=>$quarter])
    ->one();
    else
         return ReportingDetail::find()
    ->where(['financial_year_id' => $year,'vote_id'=>$vote,'source_id'=>$source])
    ->one();
}

public static function currentReportingDetail($source){
$quarter_id = null;
if(Globals::currentQuarter())
  $quarter_id  =  Globals::currentQuarter()?Globals::currentQuarter()->id:NULL;
  $year_id  =  Globals::currentYear()?Globals::currentYear()->id:NULL;
  $vote_id = Globals::myVote()?Globals::myVote()->id:NULL;
    if($source==1)
   return Globals::reportDetail($source, $vote_id, $year_id,$quarter_id);
     else
   return Globals::reportDetail($source, $vote_id, $quarter_id);
                                           
}
/**
 * Checks if user has uploaded report yet, for the current year
 * *********/
public static function hasUploadedReport($source){
    $report = Globals::currentReportingDetail($source);
    if($report)
    {
       return ReportingUpload::find()
    ->where(['reporting_detail_id' => $report->id])
    ->all(); 
    }else 
        return false;
}
/**
 * Checks if this model belongs to current logged in user.
 * Not, the model must contain a 'created_at' attributes.
 * **********/
public static  function isMine($model){
    return $model->created_by == Yii::$app->user->id?true:false;
}

public static function setMessage($type,$message){
    Yii::$app->session->setFlash($type, $message);
}

public static function getMessage($type){
    $message = "";
     if (Yii::$app->session->hasFlash('success')): 
  $message = '<span class="col-lg-12 alert alert-success alert-dismissable">'; 
$message .= '<h4><i class="icon fa fa-check"></i>'.Yii::$app->session->getFlash('success').'</h4>';
 $message .= '</span>';
  
 endif;
  if (Yii::$app->session->hasFlash('error')): 
  $message = '<span class="col-lg-12 alert alert-warning alert-dismissable">'; 
 $message .= '<h4><i class="icon fa fa-times"></i>'.Yii::$app->session->getFlash('error').'</h4>';
 $message .= '</span>';
  
 endif;
 return $message;
}
public static function can($permission){
    return Yii::$app->user->can($permission);
}
}
