<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "action_taken".
 *
 * @property integer $id
 * @property string $content
 * @property integer $plan_id
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $updated_at
 * @property integer $updated_by
 *
 * @property Plan $plan
 */
class ActionTaken extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'action_taken';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['content', 'plan_id'], 'required'],
            [['content'], 'string'],
            [['plan_id', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'integer'],
            [['plan_id'], 'exist', 'skipOnError' => true, 'targetClass' => Plan::className(), 'targetAttribute' => ['plan_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'content' => 'Actions taken, details',
            'plan_id' => 'Plan ID',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlan()
    {
        return $this->hasOne(Plan::className(), ['id' => 'plan_id']);
    }
    public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
           $this->updated_at = time();
           $this->updated_by = Yii::$app->user->id;
          
        return parent::beforeSave($insert);
    }
     public function afterSave($insert, $changedAttributes) {
             parent::afterSave($insert, $changedAttributes);
              $vote = $this->plan->vote;
          $vote->last_attended_at= time();
            $vote->last_attended_by = Yii::$app->user->id;
            $vote->update(false);
    }
}
