<?php

namespace common\models;

use Yii;
use common\helpers\Date;
use common\models\Plan;

/**
 * This is the model class for table "financial_year".
 *
 * @property integer $id
 * @property string $code
 * @property integer $start_date
 * @property integer $end_date
 * @property integer $is_current
 *
 * @property CagGeneral[] $cagGenerals
 * @property Plan[] $plans
 * @property Quarter[] $quarters
 * @property ReportingYear[] $reportingYears
 */
class FinancialYear extends \yii\db\ActiveRecord
{
    public $initial_date;
    public $final_date;
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'financial_year';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['code', 'initial_date', 'final_date'], 'required'],
            [['is_current'], 'integer'],
            [['code'], 'string', 'max' => 9],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'code' => 'Year',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'initial_date'=>'Date Start',
            'final_date'=>'Date Ends',
            'is_current' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCagGenerals()
    {
        return $this->hasMany(CagGeneral::className(), ['para_year' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlans()
    {
        return $this->hasMany(Plan::className(), ['para_year' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getQuarters()
    {
        return $this->hasMany(Quarter::className(), ['financial_year_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportingYears()
    {
        return $this->hasMany(ReportingYear::className(), ['financial_year_id' => 'id']);
    }
    
    public function beforeSave($insert) {
           $this->start_date = Date::toTimestamp ($this->initial_date);
           $this->end_date = Date::toTimestamp ($this->final_date);
           FinancialYear::updateAll(['is_current'=>0]);
        return parent::beforeSave($insert);
    }
    public function afterSave($insert, $changedAttributes) {
        
        Plan::setPreviousIssues();
        parent::afterSave($insert, $changedAttributes);
    }
    public function afterFind() {
        $this->initial_date = Date::toDateString ($this->start_date);
        $this->final_date = Date::toDateString ($this->end_date); 
        return parent::afterFind();
    }
   /**
    * 
    * @return \common\models\FinancialYear
    */
    public static function all(){
    return FinancialYear::find()->orderBy('id DESC')->all();
     
    }
}
