<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "issue_review".
 *
 * @property integer $id
 * @property string $content
 * @property integer $plan_id
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $updated_at
 * @property integer $updated_by
 */
class IssueReview extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'issue_review';
    }
    public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['content'], 'string'],
            [['plan_id','vote_id'], 'required'],
            [['plan_id','vote_id', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'content' => 'Review Descriptions',
            'plan_id' => 'Plan ID',
            'vote_id'=>'Vote',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
        ];
    }
     /**
     * @return \yii\db\ActiveQuery
     */
    public function getVote()
    {
        return $this->hasOne(Vote::className(), ['id' => 'vote_id']);
    }
      public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
           $this->updated_at = time();
           $this->updated_by = Yii::$app->user->id;
          
        return parent::beforeSave($insert);
    }
}
