<?php

namespace common\models;
use common\helpers\Date;
use Yii;


/**
 * This is the model class for table "report_notice".
 *
 * @property integer $id
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $due_date
 * @property integer $report_type
 * @property integer $financial_year_id
 * @property integer $quarter_id
 * @property integer $publish_start
 * @property integer $publish_end
 * @property integer $is_due
 */
class ReportNotice extends \yii\db\ActiveRecord
{
     public $initial_date;
    public $final_date;
    public $due_date_deadline;
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'report_notice';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [[ 'report_type','initial_date', 'financial_year_id', 'final_date', 'due_date_deadline'], 'required'],
            [['id', 'created_at', 'created_by', 'due_date', 'report_type', 'financial_year_id', 'quarter_id', 'publish_start', 'publish_end', 'is_due'], 'integer'],
        ];
    }
   public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'due_date' => 'Report Deadline',
            'report_type' => 'Report Type',
            'financial_year_id' => 'Financial Year',
            'quarter_id' => 'Quarter',
            'publish_start' => 'Report From',
            'publish_end' => 'End Publishing',
            'is_due' => 'Is Due',
            'due_date_deadline'=>'Report Deadline',
            'initial_date'=>'Start Reporting Date',
            'final_date'=>'End Publishing',
        ];
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getQuarter()
    {
        return $this->hasOne(Quarter::className(), ['id' => 'quarter_id']);
    }

     public function beforeSave($insert) {
           $this->publish_start = Date::toTimestamp ($this->initial_date);
           $this->publish_end = Date::toTimestamp ($this->final_date);
           $this->due_date = Date::toTimestamp ($this->due_date_deadline);
            if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
           
        return parent::beforeSave($insert);
    }
   public static function getPublished(){
      return self::find()
           
    //->andWhere(['>', 'publish_start', time()])
    //->andWhere(['<', 'due_date', time()])
    ->andWhere(['=', 'is_due', 0])
              ->all();
   }
   public static function getIsDue(){
      return self::find()
    //  ->andWhere(['>', 'publish_end', time()])
    //->andWhere(['<', 'due_date', time()])
    ->andWhere(['=', 'is_due', 1])
              ->all();
   }
    public function afterFind() {
        $this->initial_date = Date::toDateString ($this->publish_start);
        $this->final_date = Date::toDateString ($this->publish_end); 
        $this->due_date_deadline= Date::toDateString ($this->due_date);
        if(time()>$this->due_date){ $this->is_due=1; $this->update();}else{$this->is_due=0; $this->update();}
            
        return parent::afterFind();
    }
}
