<?php

namespace common\models;


use Yii;


/**
 * This is the model class for table "reporting_detail".
 *
 * @property integer $id
 * @property integer $financial_year_id
 * @property integer $vote_id
 * @property integer $quarter_id
 * @property integer $source_id
 * @property integer $submitted
 * @property integer $confirmed
 *
 * @property Plan[] $plans
 * @property Quarter $quarter
 * @property Source $source
 * @property Vote $vote
 * @property FinancialYear $financialYear
 */
class ReportingDetail extends \yii\db\ActiveRecord
{
    /**** DETAILS CODE **********/
    const  IAG_QR_CODE = 1;
    const  IAG_AAR_CODE = 2;
    const  IAG_AIAP_CODE = 3;
    const  IAG_AIAR_CODE = 4;
    const IAG_CAG_CODE = 5;
    const IAG_QA_CODE=6;
    const IAG_MAFUNZO_CODE=7;

    const  CAG_CG_CODE = 1;
    const  CAG_LG_CODE = 2;
    const  CAG_PAOB_CODE = 3;
    const  CAG_PA_CODE = 4;
    const  CAG_SA_CODE = 5;
    const  CAG_QA_CODE = 6;
    
    
    /********* IAG DETAILS *****************/
    const  IAG_QR_NAME = 'Quarterly Internal Audit reports';
    const  IAG_AAR_NAME = 'Special audit reports';
    const  IAG_AIAP_NAME = 'Risk Based Annual Internal Audit Plan';
    const  IAG_AIAR_NAME = 'Internal Audit charter';
    const IAG_CAG_NAME = 'Annual Internal Audit reports';
    const IAG_QA_NAME = 'Quality Assessment reports';
    const IAG_MAFUNZO_NAME = 'Ripoti ya mafunzo ya mfumo wa GARI, APRIL 2022';

    /***** CAG Details ********/
    const  CAG_CG_NAME = "Central Government";
    const  CAG_LG_NAME = "Local Government";
    const  CAG_PAOB_NAME = "Public Authority & Other Bodies";
    const  CAG_PA_NAME = "Performance Audit";
    const  CAG_SA_NAME = "Special Audit";
    const  CAG_QA_NAME = "Quality assessment"; 

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'reporting_detail';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['financial_year_id', 'vote_id', 'source_id'], 'required'],
            
            [['financial_year_id', 'vote_id', 'quarter_id', 'source_id', 'submitted', 'confirmed'], 'integer'],
            [['quarter_id'], 'exist', 'skipOnError' => true, 'targetClass' => Quarter::className(), 'targetAttribute' => ['quarter_id' => 'id']],
            [['source_id'], 'exist', 'skipOnError' => true, 'targetClass' => Source::className(), 'targetAttribute' => ['source_id' => 'id']],
            [['vote_id'], 'exist', 'skipOnError' => true, 'targetClass' => Vote::className(), 'targetAttribute' => ['vote_id' => 'id']],
            [['financial_year_id'], 'exist', 'skipOnError' => true, 'targetClass' => FinancialYear::className(), 'targetAttribute' => ['financial_year_id' => 'id']],
        ];
    }
       
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'financial_year_id' => 'Financial Year',
            'vote_id' => 'Vote',
            'quarter_id' => 'Quarter',
            'source_id' => 'Source',
            'submitted' => 'Submitted',
            'confirmed' => 'Confirmed',
        ];
    }
   public static function iagReportType($type){
         switch ($type) {
            case self::IAG_QR_CODE :
            return self::IAG_QR_NAME;

                break;
             case self::IAG_AAR_CODE:
            return  self::IAG_AAR_NAME;
                break;
             case self::IAG_AIAP_CODE:
            return self::IAG_AIAP_NAME;

                break;
             case self::IAG_AIAR_CODE:
               
                break;
                case self::IAG_MAFUNZO_CODE:
               
            return self::IAG_MAFUNZO_NAME;
                break;
            case self::IAG_CAG_CODE:
            
            return self::IAG_CAG_NAME;
                break;
            return self::CAG_SA_NAME;
                break;
            return self::CAG_QA_NAME;
                break;
            default:return "";
                break;
        }
    }
    public static function cagReportType($type){
         switch ($type) {
            case self::CAG_CG_CODE :
            return self::CAG_CG_NAME;

                break;
             case self::CAG_LG_CODE:
            return  self::CAG_LG_NAME;
                break;
             case self::CAG_PAOB_CODE:
            return self::CAG_PAOB_NAME;

                break;
             case self::CAG_PA_CODE:
            
            return self::CAG_PA_NAME;
                break;
            case self::CAG_SA_CODE:
            
            return self::CAG_SA_NAME;
                break;
            default:return "";
                break;
        }
    }
     public static function iagReportOptions(){
        $options = [];
        $options[] = ['id'=>self::IAG_MAFUNZO_CODE,'name'=>self::IAG_MAFUNZO_NAME];
        $options[] = ['id'=>self::IAG_QR_CODE,'name'=>self::IAG_QR_NAME];
        $options[] = ['id'=>self::IAG_AAR_CODE,'name'=>self::IAG_AAR_NAME];
        $options[] = ['id'=>self::IAG_AIAP_CODE,'name'=>self::IAG_AIAP_NAME];
        $options[] = ['id'=>self::IAG_AIAR_CODE,'name'=>self::IAG_AIAR_NAME];
        $options[] = ['id'=>self::IAG_CAG_CODE,'name'=>self::IAG_CAG_NAME];
        $options[] = ['id'=>self::IAG_QA_CODE,'name'=>self::IAG_QA_NAME];
        return $options;
   
        
    }
    public static function cagReportOptions(){
        $options = [];
        $options[] = ['id'=>self::CAG_CG_CODE,'name'=>self::CAG_CG_NAME];
        $options[] = ['id'=>self::CAG_LG_CODE,'name'=>self::CAG_LG_NAME];
        $options[] = ['id'=>self::CAG_PAOB_CODE,'name'=>self::CAG_PAOB_NAME];
        $options[] = ['id'=>self::CAG_PA_CODE,'name'=>self::CAG_PA_NAME];
        $options[] = ['id'=>self::CAG_SA_CODE,'name'=>self::CAG_SA_NAME];
        return $options;
   
        
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlans()
    {
        return $this->hasMany(Plan::className(), ['reporting_detail_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getQuarter()
    {
        return $this->hasOne(Quarter::className(), ['id' => 'quarter_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSource()
    {
        return $this->hasOne(Source::className(), ['id' => 'source_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getVote()
    {
        return $this->hasOne(Vote::className(), ['id' => 'vote_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
}
