<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "reporting_year".
 *
 * @property integer $id
 * @property integer $financial_year_id
 * @property integer $submitted
 *
 * @property CagGeneral[] $cagGenerals
 * @property Implementation[] $implementations
 * @property Plan[] $plans
 * @property ReportAttachment[] $reportAttachments
 * @property FinancialYear $financialYear
 */
class ReportingYear extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'reporting_year';
    }
  public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['financial_year_id'], 'required'],
            [['financial_year_id', 'submitted'], 'integer'],
            [['financial_year_id'], 'exist', 'skipOnError' => true, 'targetClass' => FinancialYear::className(), 'targetAttribute' => ['financial_year_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'financial_year_id' => 'Financial Year ID',
            'submitted' => '0=not submitted, 1=submitted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCagGenerals()
    {
        return $this->hasMany(CagGeneral::className(), ['reporting_year_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getImplementations()
    {
        return $this->hasMany(Implementation::className(), ['reporting_year_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlans()
    {
        return $this->hasMany(Plan::className(), ['reporting_year_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportAttachments()
    {
        return $this->hasMany(ReportAttachment::className(), ['reporting_year_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
}
