<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "shared_document".
 *
 * @property integer $id
 * @property string $filename
 * @property string $name
 * @property string $link
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $published
 */
class SharedDocument extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'shared_document';
    }
         public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['filename', 'name'], 'required'],
            [['created_at', 'created_by', 'published'], 'integer'],
            [['filename', 'name'], 'string', 'max' => 255],
            [['link'], 'string', 'max' => 300],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'filename' => 'Filename',
            'name' => 'Document Name',
            'link' => 'Link',
            'created_at' => 'Published on',
            'created_by' => 'Uploaded By',
            'published' => 'Published',
        ];
    }
    
      public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
        
        return parent::beforeSave($insert);
    }
    public static function getAvailable(){
      return self::find()
    ->andWhere(['=', 'published', 1])
              ->all();
   }
}
