<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "source".
 *
 * @property integer $id
 * @property string $code
 * @property string $name
 * @property integer $other_audit
 *
 * @property Plan[] $plans
 * @property ReportingDetail[] $reportingDetails
 */
class Source extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'source';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['code'], 'required'],
            [['other_audit'], 'integer'],
            [['code'], 'string', 'max' => 45],
            [['name'], 'string', 'max' => 100],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'code' => 'Code',
            'name' => 'Name',
            'other_audit' => 'Other Audit',
        ];
    }

   

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportingDetails()
    {
        return $this->hasMany(ReportingDetail::className(), ['source_id' => 'id']);
    }
    
     /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlans()
    {
        return $this->hasMany(Plan::className(), ['source_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportAttachments()
    {
        return $this->hasMany(ReportAttachment::className(), ['source_id' => 'id']);
    }
    
    public static function all(){
      return Source::find()->all(); 
    }
     public static function allCore(){
      return Source::findAll(['other_audit'=>0]); 
    }
    public static function allOtherAudit(){
      return Source::findAll(['other_audit'=>1]); 
    }
    public static function getsourcename($id){
        return Source::findOne(['id'=>$id])->code;
    }
    public function getdetail(){
        if(self::all()):
         foreach(self::all() as $source):
            if($source->code == $this->code)
                return ['url'>$this->code];
         endforeach; 
       
        endif;
    }
}
