<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "vote".
 *
 * @property integer $id
 * @property string $code
 * @property string $name
 * @property integer $group_id
 *  @property integer $last_reviewed_at
 * @property integer $last_reviewed_by
 *  @property integer $last_attended_at
 *  @property integer $last_attended_by
 * @property Plan[] $plans
 * @property ReportingDetail[] $reportingDetails
 * @property UserVote[] $userVotes
 */
class Vote extends \yii\db\ActiveRecord
{
    const TYPE_MDA = 1;
    const TYPE_PUBLIC_ENTITY = 2;
    const TYPE_LOCAL_GOVERNMENT = 3;
    
    
    const  CAN_SUBMIT_INT = 1;
    const  CAN_NOT_SUBMIT_INT = 0;
    const  CAN_SUBMIT_NAME = 'Directed to submit report';
    const  CAN_NOT_SUBMIT_NAME = 'Not directed to submit reports';

    const TYPE_NAME_MDA = 'MDA';
    const TYPE_NAME_PUBLIC_ENTITY = 'PUBLIC ENTITY';
    const TYPE_NAME_LOCAL_GOVERNMENT = 'LOCAL GOVERNMENT';
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'vote';
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['group_id','directed_to_submit','last_reviewed_at','last_reviewed_by','last_attended_at','last_attended_by'], 'integer'],
            [['code'], 'string', 'max' => 45],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'code' => 'Vote No#',
            'name' => 'Name',
            'directed_to_submit' =>'Send Report?',
            'group_id' => 'Category',
            'last_reviewed_at'=>'last Reviewed at',
            'last_reviewed_by'=>'Last reviewed By',
            'last_attended_at'=>'Last attended At',
            'last_attended_by'=>'Last attended By'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlans()
    {
        return $this->hasMany(Plan::className(), ['vote_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportingDetails()
    {
        return $this->hasMany(ReportingDetail::className(), ['vote_id' => 'id']);
    }

     /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserVotes()
    {
        return $this->hasMany(UserVote::className(), ['vote_id' => 'id']);
    }
     public static function all(){
      return self::find()->all(); 
    }
    public static function getItems(){
        $items = [];
        if(self::all()):
         foreach(self::all() as $item):
            $items[] = ['id'=>$item->id,'name'=>$item->code.': '.$item->name];
         endforeach; 
       
        endif;
        return $items;
    }
    /*
     * returns vote code, and name. 
     * 
     **/
    public function getDetail(){
        return $this->code.", ".$this->name;
    }
    
     public static function groups()
    {
        return [
            self::TYPE_MDA => Yii::t('common', self::TYPE_NAME_MDA),
            self::TYPE_PUBLIC_ENTITY => Yii::t('common', self::TYPE_NAME_PUBLIC_ENTITY),
            self::TYPE_LOCAL_GOVERNMENT => Yii::t('common', self::TYPE_NAME_LOCAL_GOVERNMENT),
           
        ];
    }
     public static function submits()
    {
        return [
            self::CAN_NOT_SUBMIT_INT => Yii::t('common', self::CAN_NOT_SUBMIT_NAME),
            self::CAN_SUBMIT_INT => Yii::t('common', self::CAN_SUBMIT_NAME),
          
        ];
    }
     public function getGroup(){
        switch ($this->group_id) {
            case self::TYPE_MDA:
            return self::TYPE_NAME_MDA;

                break;
              case self::TYPE_LOCAL_GOVERNMENT:
            return self::TYPE_NAME_LOCAL_GOVERNMENT;

                break;
             case self::TYPE_PUBLIC_ENTITY:
            return self::TYPE_NAME_PUBLIC_ENTITY;

            default: return "-";
                break;
        }
    }
     public function getCansubmit(){
        switch ($this->directed_to_submit) {
            case self::CAN_NOT_SUBMIT_INT:
            return self::CAN_NOT_SUBMIT_NAME;

                break;
              case self::CAN_SUBMIT_INT:
            return self::CAN_SUBMIT_NAME;
 default: return "-";
                break;
        }
    }
}
