<?php

namespace common\models;


use Yii;
use common\models\User;


/**
 * This is the model class for table "vote_report".
 *
 * @property integer $id
 * @property integer $vote_id
 * @property integer $type
 * @property string $filepath
 * @property string $ext
 * @property string $description
 * @property integer $financial_year_id
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $quarter_id
 */
class VoteReport extends \yii\db\ActiveRecord
{
    const  TYPE_WAITING = 0;
    const  TYPE_ACCEPTED = 1;
    const  TYPE_REJECTED = 2;
    
    const TYPE_NAME_WAITING = 'Waiting Approval';
    const  TYPE_NAME_ACCEPTED = 'Approved';
    const  TYPE_NAME_REJECTED = 'Rejected';


        /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'vote_report';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['vote_id', 'type', 'filepath', 'ext', 'financial_year_id'], 'required'],
            [['vote_id', 'type','approved', 'financial_year_id', 'created_at','approve_reject_at','approve_reject_by', 'created_by', 'quarter_id'], 'integer'],
            [['description'], 'string'],
            [['filepath'], 'string', 'max' => 255],
            [['ext'], 'string', 'max' => 5],
        ];
    }
  public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'vote_id' => 'Vote Name',
            'type' => 'Type of Report',
            'filepath' => 'Filepath',
            'ext' => 'Ext',
            'approved'=>'Approved',
            'description' => 'Description',
            'financial_year_id' => 'Financial Year',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'quarter_id' => 'Quarter',
        ];
    }
    public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
         
          
        return parent::beforeSave($insert);
    }
    
     public function getapprovedvalue(){
        switch ($this->approved) {
            case self::TYPE_ACCEPTED:
            return "<label class='label label-success'>".self::TYPE_NAME_ACCEPTED."</label>";

                break;
              case self::TYPE_WAITING:
            return "<label class='label label-warning'>".self::TYPE_NAME_WAITING."</label>";

                break;
             case self::TYPE_REJECTED:
            return "<label class='label label-danger'>".self::TYPE_NAME_REJECTED."</label>";
                break;
           
           default: return "-";
                break;
        }
    }
    
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }
     public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
    public function getVote()
    {
        return $this->hasOne(Vote::className(), ['id' => 'vote_id']);
    }
    
     public static function statusoptions(){
        $options = [];
        $options[] = ['id'=>self::TYPE_ACCEPTED,'name'=>self::TYPE_NAME_ACCEPTED];
        $options[] = ['id'=>self::TYPE_REJECTED,'name'=>self::TYPE_NAME_REJECTED];
        return $options;
   
        
    }
}