<?php

namespace common\models\query;

use common\models\User;
use Yii;
use yii\db\ActiveQuery;

/**
 * Class UserQuery
 * @package common\models\query
 * @author Eugene Terentev <eugene@terentev.net>
 */
class UserQuery extends ActiveQuery
{
    /**
     * @return $this
     */
    public function notDeleted()
    {
        return $this->andWhere('status <> ' . User::STATUS_DELETED);
        //return $this;
    }
    public function deleted()
    {
        return $this->andWhere('status = ' . User::STATUS_DELETED);
        //return $this;
    }

    /**
     * @return $this
     */
    public function active()
    {
        $this->andWhere(['status' => User::STATUS_ACTIVE]);
        return $this;
    }

    public function search($q, $voteId = NULL, $ignoreSelf = true)
    {
        $join = ['userProfile profile'];
        $this->andWhere([
            'OR',
            ['like', 'username', $q],
            ['like', 'email', $q],
            [
                'OR', ['like', 'profile.firstname', $q],
                ['like', 'profile.lastname', $q],
                ['like', 'profile.middlename', $q]
            ]
        ]);
        //exclude self 
        if ($ignoreSelf)
            $this->andWhere('user.id !=' . Yii::$app->user->id);

        if ($voteId) {
            $join[] = 'userVotes vote';
            $this->andWhere(['vote.vote_id' => $voteId]);
        }
        $this->joinWith($join);
        return $this;
    }
}
