<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Plan as PlanModel;
use common\components\Globals;
use common\models\User;

/**
 * Plan represents the model behind the search form about `common\models\Plan`.
 */
class Plan extends PlanModel
{
    /**
     * @inheritdoc
     */
    public $group_id;
    public function rules()
    {
        return [
            [['id','assigned_user_id', 'source_id', 'vote_id', 'risk', 'category_id', 'group_id', 'quarter_id', 'para_year', 'timeline', 'reporting_detail_id', 'current_previous', 'length_term', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'integer'],
            [['item_no', 'title', 'risk', 'responsible_personal', 'status'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }
    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchPlan($params)
    {
        $query = PlanModel::find();
        $query->joinWith('vote');
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);
        $query->orderBy('id DESC');

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'source_id' => $this->source_id,
            'vote_id' => $this->vote_id,
            'vote.group_id' => $this->group_id,
            'risk' => $this->risk,
            'category_id' => $this->category_id,
            'quarter_id' => $this->quarter_id,
            'para_year' => $this->para_year,
            'timeline' => $this->timeline,
            'reporting_detail_id' => $this->reporting_detail_id,
            'current_previous' => $this->current_previous, //get all previous issues
            'length_term' => $this->length_term,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
            'assigned_user_id' => $this->assigned_user_id,
        ]);



        $query->andFilterWhere(['like', 'item_no', $this->item_no])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'responsible_personal', $this->responsible_personal])
            ->andFilterWhere(['like', 'status', $this->status]);

        return $dataProvider;
    }
    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params, $source = null, $active = null, $other = null, $is_mine = 0)
    {
        $current_year = Globals::currentYear();
        //if cag previuos is selected
        if ($other) {

            $source = $other;
        };
        //set to be for CAG issues
        if ($active == 2) {
            $source = 2;
        }
        $query = PlanModel::find();
        $query->joinWith('vote');
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);
        $query->orderBy('item_no ASC');

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        //load previous issues 
        if ($active == 1) {
            $query->andFilterWhere([
                'current_previous' => 1,
            ]);
        }

        if ($source == 2 && $active == 2) {
            $query->andFilterWhere([
                'current_previous' => 1,
            ]);
        }

        if ($active == 3) {
            $query->andFilterWhere([
                'current_previous' => 0,
            ]);
        }
        if ($is_mine) {
            $query->andWhere(['assigned_user_id' => Yii::$app->user->id]);
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'source_id' => $source,
            'vote_id' => $this->vote_id,
            'vote.group_id' => $this->group_id,
            'category_id' => $this->category_id,
            'risk' => $this->risk,
            'quarter_id' => $this->quarter_id,
            'para_year' => $this->para_year,
            'timeline' => $this->timeline,
            'reporting_detail_id' => $this->reporting_detail_id,
            'current_previous' => $this->current_previous, //get all previous issues
            'length_term' => $this->length_term,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);
        //check for IA officer
        if (User::isIAOfficer()) {
            if (Globals::myVote())
                $vote_id = Globals::myVote()->id;
            else
                $vote_id = null;
            $query->andFilterWhere([

                'vote_id' => $vote_id,

            ]);
        }

        //get IAG,CAG,Other Audit current issues
        /**  if($active==3){
        $query->andFilterWhere([
           
            'current_previous' => 0,
            
        ]);
        }else{
         $query->andFilterWhere([
           
            'current_previous' => 1,
            
        ]);   
        } **/

        $query->andFilterWhere(['like', 'item_no', $this->item_no])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'responsible_personal', $this->responsible_personal])
            ->andFilterWhere(['like', 'status', $this->status]);

        return $dataProvider;
    }
    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchIssueReport($params, $status)
    {
        $query = PlanModel::find();
        $query->joinWith('vote');
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);
        $query->orderBy('id DESC');
        $query->andFilterWhere([
            'id' => $this->id,
            'vote.group_id' => $this->group_id,
            'source_id' => $this->source_id,
            'vote_id' => $this->vote_id,
            'category_id' => $this->category_id,
            'quarter_id' => $this->quarter_id,
            'para_year' => $this->para_year,
            'timeline' => $this->timeline,
            'reporting_detail_id' => $this->reporting_detail_id,
            'current_previous' => $this->current_previous, //get all previous issues
            'length_term' => $this->length_term,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);



        $query->andFilterWhere(['like', 'item_no', $this->item_no])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'responsible_personal', $this->responsible_personal])
            ->andFilterWhere(['like', 'status', $this->status]);

        if ($status == -1) //not implemented
            $query->andFilterWhere(['<>', 'status', PlanModel::STATUS_IMPLEMENTED_VALUE]);
        else
            $query->andFilterWhere([

                'status' => $status,

            ]);

        return $dataProvider;
    }

    public function searchReport($params, $previous = 0)
    {

        $query = PlanModel::find();
        $query->joinWith('vote');
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);
        $query->orderBy('id DESC');

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        if ($previous) {
            $query->andFilterWhere([

                'current_previous' => $previous,

            ]);
        }
        $query->andFilterWhere([
            'id' => $this->id,
            'source_id' => $this->source_id,
            'vote_id' => $this->vote_id,
            'vote.group_id' => $this->group_id,
            'category_id' => $this->category_id,
            'quarter_id' => $this->quarter_id,
            'para_year' => $this->para_year,
            'timeline' => $this->timeline,
            'reporting_detail_id' => $this->reporting_detail_id,
            'current_previous' => $this->current_previous,
            'length_term' => $this->length_term,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);
        //check for IA officer
        if (User::isIAOfficer()) {
            if (Globals::myVote())
                $vote_id = Globals::myVote()->id;
            else
                $vote_id = null;
            $query->andFilterWhere([

                'vote_id' => $vote_id,

            ]);
        }


        $query->andFilterWhere(['like', 'item_no', $this->item_no])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'responsible_personal', $this->responsible_personal])
            ->andFilterWhere(['like', 'status', $this->status]);

        return $dataProvider;
    }
}
