<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ReportNotice as ReportNoticeModel;

/**
 * ReportNotice represents the model behind the search form about `common\models\ReportNotice`.
 */
class ReportNotice extends ReportNoticeModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'created_at', 'created_by', 'due_date', 'report_type', 'financial_year_id', 'quarter_id', 'publish_start', 'publish_end', 'is_due'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ReportNoticeModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
      $query->orderBy('id DESC');
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'due_date' => $this->due_date,
            'report_type' => $this->report_type,
            'financial_year_id' => $this->financial_year_id,
            'quarter_id' => $this->quarter_id,
            'publish_start' => $this->publish_start,
            'publish_end' => $this->publish_end,
            'is_due' => $this->is_due,
        ]);

        return $dataProvider;
    }
}
