<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ReviewFeedback as ReviewFeedbackModel;
use common\models\User;
use common\components\Globals;

/**
 * ReviewFeedback represents the model behind the search form about `common\models\ReviewFeedback`.
 */
class ReviewFeedback extends ReviewFeedbackModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'vote_id', 'financial_year_id', 'quarter_id', 'created_at', 'created_by', 'published'], 'integer'],
            [['filename', 'name'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ReviewFeedbackModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        //check for IA officer
        if(User::isIAOfficer()){
            if(Globals::myVote())
                $vote_id = Globals::myVote()->id;
            else
                $vote_id = null;
             $query->andFilterWhere([
           
            'vote_id' => $vote_id,
            
        ]);
            
        }
        $this->load($params);
  
        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            'financial_year_id' => $this->financial_year_id,
            'quarter_id' => $this->quarter_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'published' => $this->published,
        ]);

        $query->andFilterWhere(['like', 'filename', $this->filename])
            ->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }
}
