<?php

namespace common\widgets;
use common\models\User;
use yii\helpers\ArrayHelper;

class UserSelectorWidget extends SelectorWidget
{

    public $voteId;
    public $form;
    public function run()
    {
        $selectedUser = [];
        $value = $this->model->{$this->attribute};
        if ($value)
            $selectedUser = ArrayHelper::map(User::findAll(['id'=>$value]), 'id', 'publicIdentity');
        
        return $this->render(
            'user-selector',
            [
                'model' => $this->model,
                'attribute' => $this->attribute,
                'parentHtmlNodeId' => $this->parentHtmlNodeId,
                'type' => $this->type,
                'voteId' => $this->voteId,
                'multiple' => $this->multiple,
                'selectedUser'=>$selectedUser,
                'form'=>$this->form,
            ]
        );
    }
}
