<?php

use kartik\select2\Select2;
use yii\helpers\Url;
use yii\web\JsExpression;
use yii\web\View;

?>
<?php
$voteId = $voteId ?? 0;
$formatJs = <<< JS
let jvoteId = null;
if($voteId)
 jvoteId= $voteId;
var formatRepo = function (user) {
    if(!user.id) return user.text;
    var markup =
'<div class="row">' + 
    '<div class="col-sm-7">'+
    '<div><strong>' + user.name + '</strong></div>'+
    '<div>' + user.email + '</div>'+
    '</div>' +
'</div>';
    return '<div style="overflow:hidden;">' + markup + '</div>';
};
var formatRepoSelection = function (user) {
    return user.name;
}
var formatParams =function(params) { 
    if(jvoteId)
     params.vote_id = jvoteId;

     params.q = params.term;
    return params;
}

JS;

// Register the formatting script
$this->registerJs($formatJs, View::POS_HEAD);
echo Select2::widget([
    'data' => $selectedUser,
    'model' => $model,
    'attribute' => $attribute,
    'options' => ['multiple' => false, 'placeholder' => "select User ..."],

    'pluginOptions' => [
        'allowClear' => true,
        'dropdownParent' => $parentHtmlNodeId ? "#$parentHtmlNodeId" : '',
        'ajax' => [
            'url' => Url::to(['user/default/search']),
            'dataType' => 'json',
            'data' => new JsExpression('formatParams'),
            'delay' => 250,
            'cache' => true
        ],
        'minimumInputLength' => 2,
        'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
        'templateResult' => new JsExpression('formatRepo'),
        'templateSelection' => new JsExpression('formatRepoSelection'),
    ],
]);
?>