<?php

namespace frontend\controllers;

use Yii;
use common\models\ReportingDetail;
use common\models\search\ReportDetail;
use common\models\search\CagReport as CagReportSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\ReportFormVote;
use frontend\models\ReportFormCag;
use yii\web\UploadedFile;
use common\models\VoteReport;
use common\models\CagReport;
use common\components\Globals;
use frontend\models\ReportCommentForm;

/**
 * ReportDetailController implements the CRUD actions for ReportingDetail model.
 */
class ReportDetailController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
             'access' => [
            'class' => \yii\filters\AccessControl::className(),
            'rules' => [
               
                 // allow authenticated users
                [
                    'actions' => ['uploadvote'],
                    'allow' => true,
                    'roles' => ['sendVoteReport'],
                ],
                 [
                    'actions' => ['uploadcag'],
                    'allow' => true,
                    'roles' => ['uploadGeneralReport'],
                ],
                [
                    'actions' => ['report-index'],
                    'allow' => true,
                    'roles' => ['accessReports'],
                ],  
                [
                    'actions' => ['cag-report','create','delete','downloadcag','downloadiag','index',
                        'report-index','update','comment','commentview','uploadvote','uploadcag','view','delete'],
                    'allow' => true,
                    'roles' => ['@'],
                ], 
               
        ],
                 ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['GET'],
                ],
            ]
             ];   
        
    }
    
    public function actionUploadcag()
    {
    
        $model = new ReportFormCag();
        
         if ($model->load(Yii::$app->request->post())) {
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file && $model->validate()) { 
                $random = rand(10,1000);
                $filename = $random."-".$model->file->baseName . '.' . $model->file->extension;
                $model->file->saveAs(Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadCagReportsFolder')."/".$filename);
            
             $inputFileName = Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadCagReportsFolder')."/".$filename;
              chmod($inputFileName, 0777);  //changed to add the zero
              // store in database
              $report = new CagReport();
              $report->type = $model->type;
              $report->financial_year_id = $model->financial_year_id;
              $report->filepath = $filename;
              $report->ext = $model->file->extension;
              $report->description = $model->description;
              if(!$report->save()){ print_r ($report->errors);  exit; }
             // Yii::$app->session->setFlash('success', 'successfully');
               Globals::setMessage('success', 'Successfully! uploaded report');
               return $this->redirect(['/report-detail/cag-report']);
            }
        } 
            return $this->render('upload_cag', [
                'model' => $model
            ]);
        
    }
    
    public function actionDownloadcag($file) {
  $completePath = Yii::getAlias('@frontend/web/reports/cag/'.$file);
   return Yii::$app->response->sendFile($completePath, $file,['inline'=>true]);
  
}
 public function actionDownloadiag($file) {
  $completePath = Yii::getAlias('@frontend/web/reports/iag/'.$file);

    return Yii::$app->response->sendFile($completePath, $file,['inline'=>true]);
  
}
    /**
     * Upload Report for a specific vote
     * @return type
     */
   public function actionUploadvote()
    {
    
        $model = new ReportFormVote();
        
         if ($model->load(Yii::$app->request->post())) {
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file && $model->validate()) { 
                $random = rand(10,1000);
                $filename = $random."-".$model->file->baseName . '.' . $model->file->extension;
               $model->file->saveAs(Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadIagReportsFolder')."/".$filename);
            
            $inputFileName = Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadIagReportsFolder')."/".$filename;
             
              chmod($inputFileName, 0777);  //changed to add the zero
              // store in database
              $report = new VoteReport();
              $report->vote_id = $model->vote_id;
              $report->type = $model->type;
              $report->financial_year_id = $model->financial_year_id;
              $report->quarter_id = $model->quarter_id;
              $report->filepath = $filename;
              $report->ext = $model->file->extension;
              $report->description = $model->description;
              if(!$report->save()){ print_r ($report->errors);  exit; }
             // Yii::$app->session->setFlash('success', 'successfully');
               Globals::setMessage('success', 'Successfully! uploaded report');
               return $this->redirect(['/plan/index','source'=>1,'active'=>4]);
            }
          
         }  return $this->render('upload_vote', [
                'model' => $model
            ]);
        
    }
    public function actionCagReport()
    {    
      $request = Yii::$app->request;
         
             $searchModel = new CagReportSearch();
        
        
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
             return $this->render('cagreport', [
                  'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                ]);
            
     
    }
    /**
     * Lists all ReportingDetail models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ReportDetail();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ReportingDetail model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ReportingDetail model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new ReportingDetail();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing ReportingDetail model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing ReportingDetail model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
            
    {
         $model = VoteReport::findOne($id); 
        if (!$model) 
          throw new NotFoundHttpException('The requested page does not exist.');
        $model->deleted = 1;
        $model->update();
         Globals::setMessage('success', 'Report Removed, You can re-upload it');
               return $this->redirect(['/plan/index','source'=>1,'active'=>4]);
    }
    

    /**
     * Finds the ReportingDetail model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ReportingDetail the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ReportingDetail::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
     public function actionReportIndex()
    {    
       return $this->render('report-index', [
                
                ]);
            
     
    }
    
    public function actionCommentview($id){
        $report= VoteReport::findOne($id); 
        if (!$report) 
          throw new NotFoundHttpException('The requested page does not exist.');
        return $this->renderPartial('_report_comment_view', [
                        'model' => $report
            ]);
        
    
}
    public function actionComment($id){
        $report= VoteReport::findOne($id); 
        if (!$report) 
          throw new NotFoundHttpException('The requested page does not exist.');
        $model = new ReportCommentForm();
        $model->id = $report->id;
         $loaded = $model->load(Yii::$app->request->post());
         if ($loaded) {
           //save other issues
             $report->approved = $model->status;
             $report->approve_reject_by = Yii::$app->user->id;
             $report->approve_reject_at = time();
             $report->comment = $model->content;
             if($report->update()){
                 
             Globals::setMessage('success', 'Report status changed, and comment  sent');
               return $this->redirect(['/plan/index','source'=>1,'active'=>4]);
             }
           // return $this->redirect(['view', 'id' => (string) $model->_id]);
        }elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_report_comment', [
                        'model' => $model,'id'=>$report->id
            ]);
        } else {
            return $this->render('_report_comment', [
                        'model' => $model,'id'=>$report->id
            ]);
        
    }
}
}
