<?php


namespace frontend\controllers;
use Yii;
use common\models\Plan;
use common\models\search\Plan as PlanSearch;
use common\models\search\IagReport as IagReportSearch;
use common\models\search\Vote as VoteSearch;
use common\models\search\Auditor as AuditorSearch;
use common\models\User;

class ReportsController extends \yii\web\Controller
{
    
        public function behaviors()
    {
        return [
            'access' => [
            'class' => \yii\filters\AccessControl::className(),
            'rules' => [
               
                [
                    'allow' => true,
                    'actions' => ['auditors-available','issue-search','issues-status','responsiblehq',
                        'responsiblevote','votes-attended','votes-available','votes-notattended',
                        'votes-notreviewed','votes-notsubmitted','votes-submitted'],
                    
                    'roles' => ['@'],
                ]
                
                 ],
                 ], 
          
        ];
    }
    public function actionAuditorsAvailable()
    {
         $searchModel = new AuditorSearch;
       
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
             return $this->render('auditors-available', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
        
    }

    public function actionIssueSearch()
    {
          $searchModel = new PlanSearch();
       
        $dataProvider = $searchModel->searchPlan(Yii::$app->request->queryParams);
             return $this->render('issue-search', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
        
    }
    public function actionResponsiblevote($id) {
        $model = \common\models\Vote::findOne($id);
        $auditors = [];
         $uservote = \common\models\UserVote::find()
                 ->where(['vote_id'=>$id])
                 ->all();
       
         if($uservote):
             foreach ($uservote as $u):
             $user = $u->user;
           
              if($user->type == User::TYPE_IAG_OFFICER){
                  $auditor = $user->auditor;
                  if($auditor)
                  $auditors[] = $auditor;
              }
             endforeach;
         endif;
        
       if (Yii::$app->request->isAjax) {
            return $this->renderAjax('_responsible', [
                        'model' => $model,'items'=>$auditors
            ]);
        } else {
            return $this->render('_responsible', [
                        'model' => $model,'items'=>$auditors
            ]);
        }
    }
    public function actionResponsiblehq($id) {
        $model = \common\models\Vote::findOne($id);
        $auditors = [];
         $uservote = \common\models\UserVote::find()
                 ->where(['vote_id'=>$id])
                 ->all();
         if($uservote):
             foreach ($uservote as $u):
             $user = $u->user;
              if($user->type != User::TYPE_IAG_OFFICER){
                  $auditor = $user->auditor;
                  if($auditor)
                  $auditors[] = $auditor;
              }
             endforeach;
         endif;
        
       if (Yii::$app->request->isAjax) {
            return $this->renderAjax('_responsible', [
                        'model' => $model,'items'=>$auditors
            ]);
        } else {
            return $this->render('_responsible', [
                        'model' => $model,'items'=>$auditors
            ]);
        }
    }
   
    public function actionIssuesStatus($status){
            $title="";
            if($status==Plan::STATUS_WAITING_CAG_VALUE) $title="Issues Implemented But Waiting for CAG verification";
             if($status==Plan::STATUS_IMPLEMENTED_VALUE) $title="Issues Implemented and Closed";
            if($status==Plan::STATUS_NOT_IMPLEMENTED_VALUE){
                $title="Issues Not Implemented";
                $status=-1;
            }
          $searchModel = new PlanSearch();
       
        $dataProvider = $searchModel->searchIssueReport(Yii::$app->request->queryParams,$status);
             return $this->render('issues-status', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                 'title'=>$title
                ]);
       
    }

    public function actionVotesAttended()
    {
        return $this->render('votes-attended');
    }
    
     public function actionVotesSubmitted()
    {   $searchModel = new IagReportSearch;
       
        $dataProvider = $searchModel->searchReport(Yii::$app->request->queryParams);
             return $this->render('votes-submitted', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
        
    }
 public function actionVotesNotsubmitted()
    {
       $searchModel = new IagReportSearch;
       
        $dataProvider = $searchModel->searchNotReport(Yii::$app->request->queryParams);
             return $this->render('votes-notsubmitted', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
    }

    public function actionVotesAvailable()
    {
        $searchModel = new VoteSearch;
       
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
             return $this->render('votes-available', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
       
    }

    public function actionVotesNotreviewed()
    {
         $searchModel = new VoteSearch;
       
        $dataProvider = $searchModel->searchNotReviewed(Yii::$app->request->queryParams);
             return $this->render('votes-notreviewed', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
        
    }
     public function actionVotesNotattended()
    {
         $searchModel = new VoteSearch;
       
        $dataProvider = $searchModel->searchNotAttended(Yii::$app->request->queryParams);
             return $this->render('votes-notattended', [
               'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
                
                ]);
        
    }

}
