<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace frontend\controllers;

use Yii;
use yii\web\Controller;
use frontend\models\ImportForm;
use PhpOffice\PhpSpreadsheet\IOFactory;
use common\models\ReportingDetail;
use common\models\Plan;
use common\models\Observation;
use common\models\Recommendation;
use common\models\ManagementResponse;
use common\models\AuditComment;
use yii\web\UploadedFile;
use common\models\Auditor;
use common\models\ReportNotice;
use common\helpers\Date;
/**
 * Description of SettingController
 *
 * @author vitus
 */

class SettingController extends Controller{
    //put your code here
          public function behaviors()
    {
        return [
            'access' => [
            'class' => \yii\filters\AccessControl::className(),
            'rules' => [
               
                [
                    'allow' => true,
                    'actions' => ['import','importauditor','report-notices'],
                    
                    'roles' => ['@'],
                ]
                
                 ],
                 ], 
          
        ];
    }
    public function actionImport()
    {
    
        $model = new ImportForm();
        
         if (Yii::$app->request->isPost) {
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file && $model->validate()) { 
                $random = rand(10,1000);
                $filename = $random.$model->file->baseName . '.' . $model->file->extension;
                $model->file->saveAs(Yii::getAlias('@uploadPath') ."/".$filename );
            
             $inputFileName = Yii::getAlias('@uploadPath') ."/". $filename;
              chmod($inputFileName, 0777);  //changed to add the zero
     
                //is_file($inputFileName) ? unlink($inputFileName) : "";
                //$model->transactionFile->saveAs($inputFileName);
                $spreadsheet = IOFactory::load($inputFileName);
                $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
               $result = self::reloadFile($sheetData); 
               return $this->render('import', [
                'model' => $model,'result' => $result
            ]);
            }
             
        } else {
            return $this->render('import', [
                'model' => $model
            ]);
        }
    }
    public function actionImportauditor()
    {
       
          $inputFileName = Yii::getAlias('@uploadPath') ."/auditor.xlsx";
              
                //is_file($inputFileName) ? unlink($inputFileName) : "";
                //$model->transactionFile->saveAs($inputFileName);
                $spreadsheet = IOFactory::load($inputFileName);
                $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
               self::reloadFileAuditor($sheetData); 
            
           
    }
     private static function reloadFileAuditor($data) {
        $title = $data[1];
        $count = 0;
        $failed = [];
        $imported=0;
        $verified =false;
        $verified = $title['A'] == 'vote_id' && $title['B'] == 'first_name' &&
                $title['C'] == 'middle_name' && $title['D'] == 'last_name' 
                && $title['E'] == 'title_position' && $title['F'] == 'phone_number' 
                && $title['G'] == 'email' && $title['H'] == 'gender' 
                && $title['I'] == 'data_of_birth' && $title['J'] == 'check_no' 
                && $title['K'] == 'date_of_appointment' && $title['L'] == 'highest_qualification';
                
          
        if ($verified) {
          $i = 2;
          
            while ($i <= count($data)) {
              
                $row = $data[$i];
              $vote_id = $row['A']; 
                $first_name = $row['B'];
                $middle_name = $row['C'];
                $last_name  = $row['D'];
                 $title_position = $row['E'];
                $phone_number =  $row['F'];
                $email = $row['G'];
                $gender = $row['H'];
                $date_of_birth = $row['I'];
                $check_no = $row['J'];
                $appointment = $row['K'];
                $qualification = $row['L'];
                
                 //enter auditor
               $new = new Auditor();
               $new->vote_id = $vote_id;
               $new->first_name = $first_name;
               $new->middle_name = $middle_name;
               $new->last_name = $last_name;
               $new->title_position = $title_position;
               $new->phone_number= $phone_number;
               $new->email = $email;
               $new->gender =$gender;
               
               $new->data_of_birth=Date::toTimestamp($date_of_birth);
               $new->date_of_appointment = Date::toTimestamp($appointment);
               $new->check_no="$check_no";
               $new->highest_qualification=$qualification;
               
               $i++;
               if($new->validate()){
                   if(!$new->save()){   echo $new->first_name. " not saved"; continue;}
                  
               }else{
                   print_r($new->errors); echo "Error: Username: ".$new->first_name;
                 continue; 
               }
               
                   
            }
               }
     }
    private static function reloadFile($data) {
        $title = $data[1];
        $count = 0;
        $failed = [];
        $imported=0;
        $verified =false;
        $verified = $title['A'] == 'vote_id' && $title['B'] == 'vote_name' &&
                $title['C'] == 'Para_no' && $title['D'] == 'category' 
                && $title['E'] == 'financial_year'&& $title['F'] == 'title' 
                && $title['G'] == 'cag_observation' && $title['H'] == 'cag_recommendation' 
                && $title['I'] == 'management_response'&& $title['J'] == 'cag_audit_comment' 
                 && $title['K'] == 'status' && $title['L'] == 'source_id'
                && $title['M'] == 'quarter_id'
                ;
         
        if ($verified) {
           
          $i = 2;
            while ($i <= count($data)) {
                $row = $data[$i];
                $vote_id = $row['A'];
                $para_no = $row['C'];
                $category = $row['D'];
                $financial_year_id  = $row['E'];
                 $issue_title = $row['F'];
                $observation =  $row['G'];
                $recommendation = $row['H'];
                $response = $row['I'];
                $comment = $row['J'];
                $status = $row['K'];
                $source_id = $row['L'];
                $quarter_id = $row['M'];
                 // create report detail
                $query  = ReportingDetail::find();
                    $query->andFilterWhere([
           
                'vote_id' => $vote_id,
                'source_id'=>$source_id,
                 'financial_year_id'=>$financial_year_id
                ]);
                    if($quarter_id)
                   $query->andFilterWhere([
                'quarter_id' => $quarter_id,
                
                ]);
                $report_detail = $query->one();
               if(!$report_detail){
               $report_detail = new ReportingDetail();
               $report_detail->vote_id = $vote_id;
               $report_detail->source_id = $source_id;
               $report_detail->financial_year_id = $financial_year_id;
               if($quarter_id)
               $report_detail->quarter_id = $quarter_id;
               $report_detail->save();
               }
                 //enter issue details
               $new = new Plan();
               $new->reporting_detail_id = $report_detail->id;
               $new->vote_id = $vote_id;
               $new->source_id = $source_id;
               $new->category_id = $category;
               $new->para_year = $financial_year_id;
               $new->item_no = "$para_no";
               $new->quarter_id = $quarter_id;
               $new->status = "$status";
               $new->title = $issue_title;
               
               
               if(!$new->save()){
                   //log unsaved para
                   $failed[] = ['column'=>$i];
                   $i++; $count++;
                   continue;
               }else{
                   $imported++;
               }
               //save for other details
               //save observation 
               if($observation != ""){
                   $ob = new Observation();
                   $ob->content = $observation;
                   $ob->created_at = time();
                   $ob->created_by = Yii::$app->user->id;
                   $ob->plan_id = $new->id;
                   $ob->save();
               }
               //save management r esponse
               if($response != ""){
                   $ob = new ManagementResponse();
                   $ob->content = $response;
                   $ob->created_at = time();
                   $ob->created_by = Yii::$app->user->id;
                   $ob->plan_id = $new->id;
                   $ob->save();
               }
               //save audit comment
               if($comment != ""){
                   $ob = new AuditComment();
                   $ob->content = $comment;
                   $ob->created_at = time();
                   $ob->created_by = Yii::$app->user->id;
                   $ob->plan_id = $new->id;
                   $ob->save();
               }
               //save audit comment
               if($recommendation != ""){
                   $ob = new Recommendation();
                   $ob->content = $recommendation;
                   $ob->created_at = time();
                   $ob->created_by = Yii::$app->user->id;
                   $ob->plan_id = $new->id;
                   $ob->save();
               }
                $i++; $count++;
            }
        }
  
        return ['count'=>$count,'failed'=>$failed,'imported'=>$imported,'verified'=>$verified];
    }
     public function actionReportNotices($id) {
         $items = [];
        if($id==0)
        $items = ReportNotice::getPublished ();
        else if($id==1)
            $items = ReportNotice::getIsDue ();
       if (Yii::$app->request->isAjax) {
            return $this->renderAjax('recent_reporting', [
                      'id'=>$id,'items'=>$items
            ]);
        } else {
            return $this->render('recent_reporting', [
                        'id'=>$id,'items'=>$items
            ]);
        }
    }
    
}
