<?php

namespace frontend\controllers;

use Yii;
use common\models\SharedDocument;
use common\models\search\SharedDocument as SharedDocumentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;
use frontend\models\SharedReportForm;
use yii\web\UploadedFile;
use common\components\Globals;

/**
 * SharedDocumentController implements the CRUD actions for SharedDocument model.
 */
class SharedDocumentController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
             'access' => [
            'class' => \yii\filters\AccessControl::className(),
            'rules' => [
              
                 // allow authenticated users
                [
                    'actions' => ['index'],
                    'allow' => true,
                    'roles' => ['accessPublicDocs'],
                ],
                 [
                    'actions' => [' actionUpdateupload'],
                    'allow' => true,
                    'roles' => ['uploadSharedDocs','unpublishPublicDocs'],
                ],
                 [
                    'actions' => ['bulk-delete','create','delete','download','index','update','updateupload'
                        ,'upload','user-mannual','view','viewdocs'],
                    'allow' => true,
                    'roles' => ['@'],
                ],
               
               
        ],
                 ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
                 
        ];
    }

    /**
     * Lists all SharedDocument models.
     * @return mixed
     */
    public function actionIndex()
    {    
        $searchModel = new SharedDocumentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
   public function actionUpdateupload($id)
    {
    
         $model = $this->findModel($id); 
      if ($model->load(Yii::$app->request->post())) {
            if ($model->save()) { 
              
               Globals::setMessage('success', 'Successfully! Updated');
               return $this->redirect(['/shared-document']);
            
            }
         }  return $this->render('updateupload', [
                'model' => $model
            ]);
        
    }
    public function actionUpload()
    {
    
        $model = new SharedReportForm();
        
         if ($model->load(Yii::$app->request->post())) {
            $model->file = UploadedFile::getInstance($model, 'file');

            if ($model->file && $model->validate()) { 
                $random = rand(10,1000);
                $filename = $random."-".$model->file->baseName . '.' . $model->file->extension;
               $model->file->saveAs(Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadSharedReportsFolder')."/".$filename);
            
            $inputFileName = Yii::getAlias('@frontend') ."/web/".Yii::getAlias('@uploadSharedReportsFolder')."/".$filename;
             
              chmod($inputFileName, 0777);  //changed to add the zero
              // store in database
              $report = new SharedDocument;
              $report->filename = $filename;
              $report->name = $model->description;
              $report->link = $model->link;
              $report->published = $model->published;
              
              if(!$report->save()){ print_r ($report->errors);  exit; }
             // Yii::$app->session->setFlash('success', 'successfully');
               Globals::setMessage('success', 'Successfully! Uploaded');
               return $this->redirect(['/shared-document']);
            }
          
         }  return $this->render('upload', [
                'model' => $model
            ]);
        
    }
     public function actionUserMannual() {
        
        
       if (Yii::$app->request->isAjax) {
            return $this->renderAjax('user-mannual', [
                     
            ]);
        } else {
            return $this->render('user-mannual', [
                       
            ]);
        }
    }
     public function actionDownload($file) {
  $completePath = Yii::getAlias('@frontend/web/reports/shared/'.$file);

    return Yii::$app->response->sendFile($completePath, $file,['inline'=>true]);
  
}
     public function actionViewdocs() {
        
        $items = SharedDocument::getAvailable();
        
       if (Yii::$app->request->isAjax) {
            return $this->renderAjax('viewdocs', [
                      'items'=>$items
            ]);
        } else {
            return $this->render('viewdocs', [
                        'items'=>$items
            ]);
        }
    }
  
    /**
     * Displays a single SharedDocument model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return [
                    'title'=> "SharedDocument #".$id,
                    'content'=>$this->renderAjax('view', [
                        'model' => $this->findModel($id),
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                ];    
        }else{
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }
    }

    /**
     * Creates a new SharedDocument model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $request = Yii::$app->request;
        $model = new SharedDocument();  

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Create new SharedDocument",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }else if($model->load($request->post()) && $model->save()){
                return [
                    'forceReload'=>'#crud-datatable-pjax',
                    'title'=> "Create new SharedDocument",
                    'content'=>'<span class="text-success">Create SharedDocument success</span>',
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Create More',['create'],['class'=>'btn btn-primary','role'=>'modal-remote'])
        
                ];         
            }else{           
                return [
                    'title'=> "Create new SharedDocument",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }
       
    }

    /**
     * Updates an existing SharedDocument model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);       

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Update SharedDocument #".$id,
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];         
            }else if($model->load($request->post()) && $model->save()){
                return [
                    'forceReload'=>'#crud-datatable-pjax',
                    'title'=> "SharedDocument #".$id,
                    'content'=>$this->renderAjax('view', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                ];    
            }else{
                 return [
                    'title'=> "Update SharedDocument #".$id,
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];        
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }
    }

    /**
     * Delete an existing SharedDocument model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $request = Yii::$app->request;
        $this->findModel($id)->delete();

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }


    }

     /**
     * Delete multiple existing SharedDocument model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionBulkDelete()
    {        
        $request = Yii::$app->request;
        $pks = explode(',', $request->post( 'pks' )); // Array or selected records primary keys
        foreach ( $pks as $pk ) {
            $model = $this->findModel($pk);
            $model->delete();
        }

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }
       
    }

    /**
     * Finds the SharedDocument model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return SharedDocument the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = SharedDocument::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
