<?php

namespace frontend\controllers;

use Yii;
use frontend\models\ContactForm;
use yii\web\Controller;
use frontend\models\DashboardForm;
use frontend\models\DashboardReportForm;
use common\models\Plan;
use common\models\VoteReport;
use common\models\User;

/**
 * Site controller
 */
class SiteController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'access' => [
                'class' => \yii\filters\AccessControl::className(),
                'rules' => [
                    // allow authenticated users
                        [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                        [
                        'actions' => ['contact'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                // everything else is denied
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction'
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null
            ],
            'set-locale' => [
                'class' => 'common\actions\SetLocaleAction',
                'locales' => array_keys(Yii::$app->params['availableLocales'])
            ]
        ];
    }

    

    public function actionIndex() {

        $model = new DashboardForm();
        $model_report = new DashboardReportForm();
        $query = Plan::find();
        $implemented_query = Plan::find();
        $inprogress_query = Plan::find();
        $query_report = VoteReport::find();
        //if is a vote user 
        $assignedvote = \common\components\Globals::myVote();
        if (User::isIAOfficer() && $assignedvote) {
            $query->andFilterWhere([
                'vote_id' => $assignedvote->id
            ]);
            $implemented_query->andFilterWhere([
                'vote_id' => $assignedvote->id
            ]);
            $inprogress_query->andFilterWhere([
                'vote_id' => $assignedvote->id
            ]);
        }
        //when filter is applied
        if ($model->load(Yii::$app->request->post())) {

            //if source is set
            if ($model->source_id) {
                $query->andFilterWhere([
                    'source_id' => $model->source_id,
                ]);
                $implemented_query->andFilterWhere([
                    'source_id' => $model->source_id,
                ]);
                $inprogress_query->andFilterWhere([
                    'source_id' => $model->source_id,
                ]);
            }

            if ($model->vote_id) {
                $query->andFilterWhere([
                    'vote_id' => $model->vote_id,
                ]);
                $implemented_query->andFilterWhere([
                    'vote_id' => $model->vote_id,
                ]);
                $inprogress_query->andFilterWhere([
                    'vote_id' => $model->vote_id,
                ]);
            }
            if ($model->year_start_id) {
                $query->andFilterCompare('para_year', $model->year_start_id, '>=');
                $implemented_query->andFilterCompare('para_year', $model->year_start_id, '>=');
                $inprogress_query->andFilterCompare('para_year', $model->year_start_id, '>=');
            }
            if ($model->year_end_id) {
                $query->andFilterCompare('para_year', $model->year_end_id, '<=');
                $implemented_query->andFilterCompare('para_year', $model->year_end_id, '<=');
                $inprogress_query->andFilterCompare('para_year', $model->year_end_id, '<=');
            }
        }
        //filter for report
        if ($model_report->load(Yii::$app->request->post())) {
            if ($model_report->report_financial_year_id)
                $query_report->andFilterWhere([
                    'financial_year_id' => $model_report->report_financial_year_id,
                ]);
            if ($model_report->report_type)
                $query_report->andFilterWhere([
                    'type' => $model_report->report_type,
                ]);
            if ($model_report->report_quarter_id)
                $query_report->andFilterWhere([
                    'quarter_id' => $model_report->report_quarter_id,
                ]);
        }
        //total
        $total = $query->count();
        $total_report = $query_report->count();
        //get all votes
        $allvotes = \common\models\Vote::all();
        if ($model_report->submitted == 2)
            $total_report = count($allvotes) - $total_report;

        //implemented

        $implemented = $implemented_query->andFilterWhere([
                    'status' => Plan::STATUS_IMPLEMENTED_VALUE,
                ])->count();

        $inprogress = $inprogress_query->andFilterWhere([
                    'status' => Plan::STATUS_INPROGRESS_VALUE,
                ])->count();

        //inprogress


        $dashboard = [];
        $dashboard['total'] = $total;
        $dashboard['implemented'] = $implemented;
        $dashboard['inprogress'] = $inprogress;


        return $this->render('index', ['model' => $model, 'model_report' => $model_report, 'dashboard' => $dashboard, 'report_count' => $total_report]);
    }

    public function actionContact() {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($model->contact(Yii::$app->params['adminEmail'])) {
                Yii::$app->getSession()->setFlash('alert', [
                    'body' => Yii::t('frontend', 'Thank you for contacting us. We will respond to you as soon as possible.'),
                    'options' => ['class' => 'alert-success']
                ]);
                return $this->refresh();
            } else {
                Yii::$app->getSession()->setFlash('alert', [
                    'body' => \Yii::t('frontend', 'There was an error sending email.'),
                    'options' => ['class' => 'alert-danger']
                ]);
            }
        }

        return $this->render('contact', [
                    'model' => $model
        ]);
    }

}
