<?php

namespace frontend\controllers;

use Yii;
use common\models\Source;
use common\models\search\Source as SourceSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\VoteForm;
use common\models\Plan;
use frontend\models\GeneralReportForm;

/**
 * SourceController implements the CRUD actions for Source model.
 */
class SourceController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Source models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SourceSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Source model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
   
    public function actionChoosevotecag($source,$active)
    {
        if($active==1)
        $model = new VoteForm();
        if($active==2)
            $model = new GeneralReportForm;

        if ($model->load(Yii::$app->request->post()) ) {
            //return $this->redirect(['view', 'id' => $model->id]);
            return $this->render('entercag', [
                'model' => $model,'source'=>$source,'active'=>$active,'id'=>$model->id
            ]);
        }
        
            return $this->render('entercag', [
                'model' => $model,'source'=>$source,'active'=>$active
            ]);
        
    }
    public function actionItemdetail($source,$active,$detail_id=null)
    {
        $model = new VoteForm();

        if ($model->load(Yii::$app->request->post()) ) {
            //return $this->redirect(['view', 'id' => $model->id]);
            return $this->render('paradetail', [
                'model' => $model,'source'=>$source,'active'=>$active,'id'=>$model->id
            ]);
        }
        
            return $this->render('paradetail', [
                'model' => $model,'source'=>$source,'active'=>$active,'detail_id'=>$detail_id,
            ]);
        
    }
 public function actionChoosevoteiag($source,$active)
    {
        $votemodel = new VoteForm();
        $request = Yii::$app->request;
        $model = new Plan();  

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Add New Issue",
                    'content'=>$this->renderAjax('enteriag', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }else if($model->load($request->post()) && $model->save()){
                return [
                    'forceReload'=>'#crud-datatable-pjax',
                    'title'=> "Add New Issue",
                    'content'=>'<span class="text-success">Issue added Successfully</span>',
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Add More',['create'],['class'=>'btn btn-primary','role'=>'modal-remote'])
        
                ];         
            }else{           
                return [
                    'title'=> "Add New Issue",
                    'content'=>$this->renderAjax('enteriag', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }
        }
        else{
            /*
            *   Process for non-ajax request
            */
            if ($votemodel->load($request->post())) {
               
                 return $this->render('enteriag', [
                'model' => $model,'source'=>$source,'active'=>$active,'id'=>$votemodel->id,'votemodel'=>$votemodel
                ]);
            } else {
            
                return $this->render('enteriag', [
                'model' => $model,'source'=>$source,'active'=>$active,'id'=>$votemodel->id,'votemodel'=>$votemodel
                ]);
            }
        }
        
/***
        if ($model->load(Yii::$app->request->post()) ) {
            //return $this->redirect(['view', 'id' => $model->id]);
            return $this->render('enteriag', [
                'model' => $model,'source'=>$source,'active'=>$active,'id'=>$model->id
            ]);
        }
        
            return $this->render('enteriag', [
                'model' => $model,'source'=>$source,'active'=>$active
            ]);
        ***/
    }
    public function actionEnter($id)
    {
            $view = null;
        switch ($id) {
            case 1: $view="enteriag";
                break;
             case 2: $view="entercag";
                break;
             case 3: $view="enterpac";
                break;
            default:
                break;
        }
        return $this->render($view, [
            'model' => $this->findModel($id),'source'=>$id
        ]);
    }
    /**
     * Creates a new Source model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Source();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Source model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Source model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Source model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Source the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Source::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
