<?php

namespace frontend\models;

use Yii;
use yii\base\Model;

/**
 * ContactForm is the model behind the contact form.
 */
class DashboardForm extends Model
{
    
    public $source_id;
    public $vote_id;
    public $year_start_id;
    public $year_end_id;
   

    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['source_id','vote_id','year_start_id','year_end_id'
                ], 'integer'],
           

        ];
    }

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            'vote_id' => Yii::t('frontend', 'Vote'),
            'source_id' => Yii::t('frontend', 'Source'),
            'year_start_id' => Yii::t('frontend', 'From'),
            'year_end_id' => Yii::t('frontend', 'To'),
            
           
        ];
    }

}
