<?php

namespace frontend\models;

use Yii;
use yii\base\Model;

/**
 * ContactForm is the model behind the contact form.
 */
class GeneralReportForm extends Model
{
    public $id;
    public $name;
    const  MDA_TYPE =1;
    const  LGA_TYPE = 2;
    const  SPECIAL_TYPE=3;
    const  PUBLIC_TYPE=4;
    const  PROJECT_TYPE=5;
    const  MDA_TYPE_NAME ='MDA Audit';
    const  LGA_TYPE_NAME = 'LGA Audit';
    const  SPECIAL_TYPE_NAME='Special Audit';
    const  PUBLIC_TYPE_NAME='Public Authorities';
    const  PROJECT_TYPE_NAME='Projects';

    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['id'], 'required'],
           

        ];
    }

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('frontend', 'Type of Report'),
           
        ];
    }
    
    public static function caglist(){
        return [
            ['id'=>self::MDA_TYPE,'name'=>self::MDA_TYPE_NAME],
            ['id'=>self::LGA_TYPE,'name'=>self::LGA_TYPE_NAME],
            ['id'=>self::SPECIAL_TYPE,'name'=>self::SPECIAL_TYPE_NAME],
            ['id'=>self::PUBLIC_TYPE,'name'=>self::PUBLIC_TYPE_NAME],
            ['id'=>self::PROJECT_TYPE,'name'=>self::PROJECT_TYPE_NAME],
           
        ];
    }
    public static function  getReportName($id){
        switch ($id) {
            case self::MDA_TYPE: return self::MDA_TYPE_NAME;
                break;
           case self::LGA_TYPE: return self::LGA_TYPE_NAME;
                break;
            case self::SPECIAL_TYPE: return self::SPECIAL_TYPE_NAME;
                break;
            case self::PUBLIC_TYPE: return self::PUBLIC_TYPE_NAME;
                break;
            case self::PROJECT_TYPE: return self::PROJECTS_TYPE_NAME;
                break;
            default: return "None";
                break;
        }
    }

}
