<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use common\models\ReportingDetail;

/**
 * ContactForm is the model behind the contact form.
 */
class ReportFormCag extends Model
{
    
    public  $file;
   
    public  $financial_year_id;

    public  $description;
    public  $type;
    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
             [['file', 'type','financial_year_id'], 'required'],
             [['file','type','description','financial_year_id'], 'safe'],
            [['file'], 'file', 'extensions'=>'pdf, doc, docx,xlsx'],
         
           

        ];
    }
     

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            
            'file' => Yii::t('frontend', 'File to Upload'),
            'financial_year_id' => Yii::t('frontend', 'Financial Year'),
            'description' => Yii::t('frontend', 'File Description'),
           
            'type'=>Yii::t('frontend', 'Type of Report'),
            
           
           
        ];
    }

}
