<?php

namespace frontend\models;

use Yii;
use yii\base\Model;


/**
 * ContactForm is the model behind the contact form.
 */
class SharedReportForm extends Model
{
    
    public  $file;
   
    public  $link;
    public  $description;
    public $published;
   
    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
             [['file', 'description','published'], 'required'],
             [['file','description','link'], 'safe'],
            [['file'], 'file', 'extensions'=>'pdf, doc, docx,xlsx'],
         
           

        ];
    }
     

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            
            'file' => Yii::t('frontend', 'Document to Upload'),
            'link' => Yii::t('frontend', 'Web Link'),
            'description' => Yii::t('frontend', 'Document Name'),
            'published' => Yii::t('frontend', 'Publish'),
           
           
        ];
    }

}
