<?php

namespace frontend\modules\user\controllers;

use common\base\MultiModel;
use common\models\User;
use frontend\modules\user\models\AccountForm;
use Intervention\Image\ImageManagerStatic;
use trntv\filekit\actions\DeleteAction;
use trntv\filekit\actions\UploadAction;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;

class DefaultController extends Controller
{
    /**
     * @return array
     */
    public function actions()
    {
        return [
            'avatar-upload' => [
                'class' => UploadAction::className(),
                'deleteRoute' => 'avatar-delete',
                'on afterSave' => function ($event) {
                    /* @var $file \League\Flysystem\File */
                    $file = $event->file;
                    $img = ImageManagerStatic::make($file->read())->fit(215, 215);
                    $file->put($img->encode());
                }
            ],
            'avatar-delete' => [
                'class' => DeleteAction::className()
            ]
        ];
    }

    /**
     * @return array
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@']
                    ]
                ]
            ]
        ];
    }

    /**
     * @return string|\yii\web\Response
     */
    public function actionIndex()
    {
        $accountForm = new AccountForm();
        $accountForm->setUser(Yii::$app->user->identity);

        $model = new MultiModel([
            'models' => [
                'account' => $accountForm,
                'profile' => Yii::$app->user->identity->userProfile
            ]
        ]);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $locale = $model->getModel('profile')->locale;
            Yii::$app->session->setFlash('forceUpdateLocale');
            Yii::$app->session->setFlash('alert', [
                'options' => ['class'=>'alert-success'],
                'body' => Yii::t('frontend', 'Your account has been successfully saved', [], $locale)
            ]);
            return $this->refresh();
        }
        return $this->render('index', ['model'=>$model]);
    }

    
    public function actionSearch($q = null, $id = null, $vote_id = null)
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => [$this->formatSearch()]];
        if (!is_null($q)) {
            $users = User::find()->search($q,voteId:$vote_id,ignoreSelf:false)->limit(20)->all();
            $formatUser = [];
            foreach ($users as $user) {
                $formatUser[] = $this->formatSearch($user);
            }
            if ($formatUser)
                $out['results'] = $formatUser;
        } elseif ($id > 0) {
            $out['results'] = [$this->formatSearch(User::findOne(['id' => $id]))];
        }
        return $out;
    }

    private function formatSearch(?User $user = NULL)
    {
        $data = ['id' => '', 'name' => '', 'email' => '', 'avatar' => ''];
        if ($user) {
            $data['id'] = $user->id;
            $data['name'] = $user->publicIdentity;
            $data['email'] = $user->email;
            $data['avatar'] = $user->userProfile->avatar;
        }

        return $data;
    }
}
