<?php
use yii\helpers\Url;
use common\components\Globals;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Auditor;

return [
   
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    
   
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'fullname',
    ],
                 [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'gender',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(Auditor::genderoptions(), 'id', 'name'),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->genderName;
         },
    ],
    
                  [
        'class'=>'\kartik\grid\DataColumn',
        'label'=>'Assigned Votes',
         'format' => 'raw',
      
        'value' => function($model) {
                    return $model->user?$model->user->votesvalue:"";
         },
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'title_position',
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
         'visibleButtons' => [
        'view' => Globals::can('accessCommittee'),
         'update'=>Globals::can('editCommitteeMember') || Globals::can('updateOwnCommitteeMember'),
         'delete'=>Globals::can('removeCommitteeMember'),
         ],
        'dropdown' => false,
          
        'vAlign'=>'middle',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'viewOptions'=>['role'=>'modal-remote','title'=>'View','data-toggle'=>'tooltip'],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update', 'data-toggle'=>'tooltip'],
        'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], 
    ],
         

];   