<?php

use yii\widgets\DetailView;
use common\components\Globals;
use common\models\User;

/* @var $this yii\web\View */
/* @var $model common\models\Auditor */
?>
<div class="auditor-view">
    <?=
    DetailView::widget([
        'model' => $model,
        'attributes' => [
            'first_name',
            'middle_name',
            'last_name',
            [
                'label' => 'Gender',
                'value' => $model->genderName,
            ],
            'title_position',
            'phone_number',
            'email:email',
            [
                'label' => 'Vote',
                'value' => $model->user ? $model->user->votesvalue : "",
            ],
            
            ['label' => 'Appointment Start Date',
                'value' => $model->appointmentStartDate ?: "-",
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Appointment End Date',
                'value' => $model->appointmentEndDate ?: "-",
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Highest Qualification',
                'value' => \common\models\Options::qualifications()[$model->highest_qualification],
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Appointment Letter',
                'value' => function($model) {
                    $link = $model->letterLink ? \yii\helpers\Html::a("download", $model->letterLink,['target'=>'_blank']) : NULL;
                    $uploadLink = \yii\helpers\Html::a("Add New", ["committee-member/upload-letter", "id" => $model->id]);
                    return implode(" | ", [$link,$uploadLink]);
                },
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
                'format' => 'raw'
            ]
        ],
    ])
    ?>

</div>
