<?php

use yii\helpers\Url;
use kartik\sidenav\SideNav;
use yii\helpers\Html;
use common\models\ReportNotice;
use common\models\User;
use common\components\Globals;

/* @var $this \yii\web\View */
/* @var $content string */
//FrontendAsset::register($this);
$this->beginContent('@frontend/views/layouts/_clear.php')
?>

<div id="page-loader" class="fade"><span class="spinner"></span></div>
s
<!-- end #page-loader -->

<!-- begin #page-container -->
<div id="page-container" class="page-sidebar-fixed page-header-fixed">
	<div id="header" class="header navbar navbar-default navbar-fixed-top">
		<!-- begin container-fluid -->
		<div class="container-fluid">
			<!-- begin mobile sidebar expand / collapse button -->
			<div class="navbar-header">

				<a href="<?= Url::to(['/site/index']) ?>" class="navbar-brand"> <?= Html::img(Yii::getAlias('@web') . '/img/logogari.PNG'); ?></a>
				<button type="button" class="navbar-toggle" data-click="sidebar-toggled">
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>

			</div>
			<div class="notice-alert">
				<?php if (ReportNotice::getPublished()) : ?>
					<a title='View Notices' href="#" class='showModal btn-small ' data-title='Reports Notices' data-url='<?= Url::to(['/setting/report-notices', 'id' => 0]) ?>'>
						<!-- end mobile sidebar expand / collapse button -->
						<div style="margin-bottom: 0" class="nav navbar-nav alert alert-info fade in col-md-2  pull-left">
							<strong>Info!</strong>
							Reporting Notices available, View Details <i class="fa fa-forward"></i>

							<?= Html::img('@web/img/cropcrop.gif', ["width" => "12px"]); ?>
						</div>
					</a>
				<?php endif; ?>
				<!-- end mobile sidebar expand / collapse button -->
				&nbsp;
				<?php if (ReportNotice::getIsDue()) : ?>
					<a title='View Due Report Dates' href="#" class='showModal btn-small ' data-title='Recent Due Reports' data-url='<?= Url::to(['/setting/report-notices', 'id' => 1]) ?>'>
						<div style="margin-bottom: 0" class="nav navbar-nav alert alert-danger fade in col-md-2  pull-left">
							<strong>Notice!</strong>
							Recent Due Reports available, View Details <i class="fa fa-forward"></i>
							<?= Html::img('@web/img/cropcrop.gif', ["width" => "12px"]); ?>


						</div>
					</a>
				<?php endif; ?>
				<?php if (Globals::can('accessPublicDocs')) : ?>
					<a title='View Shared Docs' href="#" class='showModal btn-small ' data-title='Shared Documents' data-url='<?= Url::to(['/shared-document/viewdocs']) ?>'>
						<div style="margin-bottom: 0" class="nav navbar-nav alert alert-info fade in col-md-2  pull-left">
							<strong>
								Notice: </strong> Shared Documents,View Details <i class="fa fa-forward"></i>

							<?= Html::img('@web/img/cropcrop.gif', ["width" => "12px"]); ?>
						</div>
					</a>
				<?php endif; ?>
				<a title="Preview User manual" target="_blank" href='http://154.118.227.171/frontend/web/ARI-ITS-User-Manual-v.1.0.pdf'>
					<div style="margin-bottom: 0" class="nav navbar-nav alert alert-info fade in col-md-2  pull-left">
						<?= Html::img('@web/img/help.gif', ["width" => "35px"]); ?>
						<strong style="font-size: 17px;">
							User Manual </strong> <i class="fa fa-forward"></i>

					</div>
				</a>
			</div>
			<!-- begin header navigation right -->
			<ul class="nav navbar-nav navbar-right">



				<li class="navbar-user">
					<a href="<?= Url::to(['/user']) ?>">

						<span class="hidden-xs cuttext"><?php echo substr(Yii::$app->user->identity->username, 0, 10) ?></span>
					</a>

				</li>
				<li class="navbar-user">
					<?php echo Html::a("<i class='fa fa-lock'></i> " . Yii::t('frontend', 'Logout'), ['/user/sign-in/logout'], ['title' => 'Sign out']) ?>


				</li>

			</ul>
			<!-- end header navigation right -->
		</div>
		<!-- end container-fluid -->
	</div>
	<div id="sidebar" class="sidebar">
		<!-- begin sidebar scrollbar -->
		<div data-scrollbar="true" data-height="100%">
			<?php
			echo SideNav::widget([
				'type' => SideNav::TYPE_PRIMARY,
				'iconPrefix' => 'fa fa-',
				//'heading' => 'Options',
				'items' => [
					[
						'url' =>  Url::to(['/site/index']),
						'label' => 'Dashboard',
						'icon' => 'home'
					],
					[
						'url' => Url::to(['/plan/index', 'source' => 1, 'active' => 3, 'is_mine' => 1]),
						'label' => 'Assigned Issues',
						'icon' => 'angle-double-right'
					],
					[
						'url' => Url::to(['/plan/index', 'source' => 1, 'active' => 3]),
						'label' => 'IA Area',
						'icon' => 'angle-double-right',
						'visible' => Globals::can('accessIAGArea')
					],

					[
						'url' =>  Url::to(['/plan/cag']),
						'label' => 'CAG Area',
						'icon' => 'angle-double-left',
						'visible' => Globals::can('accessCAGArea')
					],

					/**[
						'url' =>  Url::to(['/auditor']),
						'label' => 'Internal Auditors Database',
						'icon' => 'align-justify',
						'visible' => Globals::can('accessAuditors')
					], ***/
				/*	[
						'url' =>  Url::to(['/committee-member']),
						'label' => 'Commitee Members',
						'icon' => 'align-justify',
						'visible' => !User::isIAOfficer()
					], */
					[
						'url' =>  Url::to(['/report-detail/report-index']),
						'label' => 'Outputs / Reports',
						'icon' => 'clipboard',
						'visible' => Globals::can('accessReports')
					],
					[
						'url' =>  Url::to(['/shared-document']),
						'label' => 'Shared Document',
						'icon' => 'paperclip',
						'visible' => Globals::can('accessPublicDocs')
					],
					[
						'url' =>  Url::to(['/review-feedback']),
						'label' => 'Review Feedback',
						'icon' => 'check-circle',
						'visible' => Globals::can('accessReviewFeedback')
					],
					[
						'url' =>  Url::to(['/report-notice']),
						'label' => 'Reporting Deadlines',
						'icon' => 'bell',
						'visible' => Globals::can('accessReportingDeadline')
					],

					/**[
						'url' =>  Url::to(['/setting/import']),
						'label' => 'Import Tool',
						'icon' => 'fa fa-cogs',
						'visible' => Globals::can('importTool')
					],**/
					[
						'url' =>  Url::to(['/vote']),
						'label' => 'Votes',
						'icon' => 'align-justify',
						'visible' => Globals::can('accessVotes')
					],
					[
						'url' =>  Url::to(['/category']),
						'label' => 'Categories',
						'icon' => 'align-justify',
						'visible' => Globals::can('accessIssueCategory')
					],
					[
						'url' =>  Url::to(['//financial-year/index']),
						'label' => 'Financial Years',
						'icon' => 'align-justify',
						'visible' => Globals::can('accessFinancialYear')
					],
					[
						'url' =>  Url::to(['/quarter/index']),
						'label' => 'Quarters',
						'icon' => 'align-justify',
						'visible' => Globals::can('accessQuarter')
					],
					[
						'url' =>  Url::to(['/source/index']),
						'label' => 'Sources',
						'icon' => 'align-justify',
						'visible' => Globals::can('administrator')
					],



				],
			]);

			?>
			<!-- end sidebar user -->

		</div>
		<!-- end sidebar scrollbar -->
	</div>
	<div id="content" class="content">

		<?php echo $content ?>
	</div>

</div>

<footer class="footer">
	<p class="pull-left">&copy; GARI-ITS <?php echo date('Y') ?></p>

</footer>
<?= $this->render('modal') ?>
<?php $this->endContent() ?>