<?php
use yii\widgets\ActiveForm;
use yii\helpers\Url;
use common\models\FinancialYear;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use common\models\Category;
use common\models\Source;
use common\models\Plan;
use kartik\depdrop\DepDrop;


/* @var $this yii\web\View */
/* @var $model common\models\Plan */
/* @var $form yii\widgets\ActiveForm */
?>
<div class="alert alert-warning">Use this window to add previous and current issues</div>
<div class="plan-form">

    <?php $form = ActiveForm::begin(); ?>
   <?php
         $sources = Source::all();
          $listData=ArrayHelper::map($sources,'id','name'); 
        echo $form->field($model, 'source_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select  ...', 'id'=>'other_audit_id','prompt'=>'Select  ...'],
    'pluginOptions' => [
        //'allowClear' => true
    ],
]);  
        ?>
    
    

    <?= $form->field($model, 'item_no')->textInput(['maxlength' => true,'placeholder'=>'Enter Para no.']) ?>
    
    <?= $form->field($model, 'title')->textArea(['rows'=>3,'maxlength' => true,'placeholder'=>'Enter or Copy & Paste Observation /Directive']) ?>
           <?php
        
        $categories= Category::find()->all();
          $listData=ArrayHelper::map($categories,'id','name'); 
        echo $form->field($model, 'category_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...', 'id'=>'cate_id'],
    'pluginOptions' => [
        //'allowClear' => false
    ],
]);
        ?>
    
      <?php
        
        $priorities = Plan::getPriorityOptions();
          $listData=ArrayHelper::map($priorities,'id','name'); 
        echo $form->field($model, 'priority_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...', 'id'=>'priority_id'],
    'pluginOptions' => [
        //'allowClear' => false
    ],
]);
        ?>
    
    
    <div class="col-md-6">
  <?php
        
        $years= FinancialYear::all();
          $listData=ArrayHelper::map($years,'id','code'); 
        echo $form->field($model, 'para_year')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select year.','id'=>'year_id','class'=>'form-control','prompt'=>'Select year.'],
    'pluginOptions' => [
        //'allowClear' => true
    ],
]);
        ?></div><div class="col-md-6" id="quarterid">
    <?=
           $form->field($model, 'quarter_id')->widget(DepDrop::classname(), [
     'options' => ['id'=>'quarter-id','class'=>'form-control'],
     'pluginOptions'=>[
         'depends'=>['year_id'],
         'placeholder' => 'Select...',
         'url' => Url::to(['/quarter/list'])
     ]
 ]);
            
        ?></div>
    
    

    <?php ActiveForm::end(); ?>
    
</div>
