<?php

use yii\helpers\Url;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use kartik\grid\GridView;
use johnitvn\ajaxcrud\CrudAsset;
use johnitvn\ajaxcrud\BulkButtonWidget;
use kartik\export\ExportMenu;

use common\models\User;
use common\models\Source;
use  common\components\Globals;

/* @var $this yii\web\View */
/* @var $searchModel common\models\search\Plan */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Plans';

CrudAsset::register($this);

?>

<div class="col-md-12 ui-sortable">
    <!-- begin panel -->
    <div class="panel panel-info">
        <div class="panel-heading">

            <h4 class="panel-title">Welcome to <?= Source::getsourcename($source) ?> Working Area</h4>

        </div>

        <div class="panel-body">
            <h4><b><?= Source::getsourcename($source) ?>:</b> Current Reporting Year- <?= Globals::currentYear()->code; ?>: <b><?php $current_q = Globals::currentQuarter();
                                                                                                                                echo ($source == 1 && $current_q) ? Globals::currentQuarter()->code : "" ?></b>
                <?php if (!Globals::myVote() && User::isIAOfficer()) : ?>
                    <span class="pull-right  alert-danger">You're not assigned Vote, Contact Admin</span>
                <?php
                elseif (Globals::myVote() && !Globals::currentReportingDetail($source) && User::isIAOfficer() && isset($active) && $active == 3 && $source == 1) : ?>
                    <span class="pull-right  alert-danger">Management Letter / Report not Submitted
                        <a title='Activate Reporting year' href="#" class='showModal btn  btn-small btn-success' data-title='Activate Reporting Year' data-url='<?= Url::to(['plan/startreport', 'source' => $source, 'active' => isset($active) ? $active : 3]) ?>'><i class='fa fa-plus'></i> activate Reporting Year</a>
                    </span>
                <?php elseif (Globals::myVote() && Globals::can('sendVoteReport') &&  !Globals::hasUploadedReport($source) && User::isIAOfficer() && $source == 1) : ?>

                    <a title='Upload Report' href="<?= Url::to(['/report-detail/uploadvote']); ?>" class='btn btn-small btn-success pull-right'><i class='fa fa-upload'></i> Upload Report</a>

                <?php endif; ?>
                <?php if ((isset($source) && $source == 1) || (isset($id) && $id == 1)) : ?>
                    <a title='View Review Feedbacks' href="<?= Url::to(['/review-feedback']); ?>" class='btn btn-small btn-success pull-right'><i class='fa fa-clipboard'></i> Review Feedback</a>

                <?php endif; ?>

            </h4>
            <div id="wizard" class="bwizard clearfix">
                <?= Globals::getMessage('success') ?>
                <?php $params = Yii::$app->request->queryParams; ?>
                <span><b>Choose what area to continue</b></span>
                <ol class="bwizard-steps clearfix clickable" role="tablist">
                    <a href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 1] + $params); ?>">
                        <li role="tab" aria-selected="true" class="<?= (isset($active) && $active == 1) ? 'active' : ''; ?>" style="z-index: 4; <?= (isset($active) && $active == 1) ? ' color:#fff !important' : ''; ?> "><span class="label badge-inverse"></span>
                            <?= Source::getsourcename($source) ?> Previous Recommendations
                        </li>
                    </a>
                    &nbsp;<?php if ($source == 1) : ?>
                    <a href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 2]+ $params); ?>">
                        <li role="tab" aria-selected="true" class="<?= (isset($active) && $active == 2) ? 'active' : ''; ?>" style="z-index: 4; <?= (isset($active) && $active == 2) ? ' color:#fff !important' : ''; ?> "><span class="label badge-inverse"></span>
                            CAG Previous Recommendations
                        </li>
                    </a>

                <?php endif; ?>
                &nbsp;
                <?php if ($source == 1) : ?>
                    <a href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 5]+ $params); ?>">
                        <li role="tab" aria-selected="true" class="<?= (isset($active) && $active == 5) ? 'active' : ''; ?>" style="z-index: 4; <?= (isset($active) && $active == 5) ? ' color:#fff !important' : ''; ?> "><span class="label badge-inverse"></span>
                            Other Oversights
                        </li>
                    </a>
                <?php endif; ?>
                &nbsp;
                <a href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 3]+ $params); ?>">
                    <li role="tab" aria-selected="true" class="<?= (isset($active) && $active == 3) ? 'active' : ''; ?>" style="z-index: 4; <?= (isset($active) && $active == 3) ? ' color:#fff !important' : ''; ?> "><span class="label badge-inverse"></span>
                        <?= Source::getsourcename($source) ?> Current observations/directive
                    </li>
                </a>
                &nbsp;
                <?php if ($source == 1) : ?> <a href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 4]+ $params); ?>">
                        <li role="tab" aria-selected="true" class="<?= (isset($active) && $active == 4) ? 'active' : ''; ?>" style="z-index: 4; <?= (isset($active) && $active == 4) ? ' color:#fff !important' : ''; ?> "><span class="label badge-inverse"></span>
                            <?= User::isIAOfficer() ? 'My Reports' : 'Reports'; ?>
                        </li>
                    </a>
                <?php endif; ?>

                </ol>
                <?php if (isset($active) && $active == 5) :
                    $otheraudits = Source::allOtherAudit();
                    $other = isset($other) ? $other : null;

                    foreach ($otheraudits as $o) :
                ?>

                        <a class="btn btn-small <?= $other == $o->id ? ' btn-success' : ' btn-default'; ?>" href="<?= Url::to(['/plan/index', 'source' => $source, 'active' => 5, 'other' => $o->id]+ $params); ?>"><?= $o->name; ?></a>
                    <?php endforeach;
                    if ($other) { ?>

                        <a class="btn btn-small pull-right btn-default" href="<?= Url::to(['/plan/index', 'source' => $other, 'active' => 3]); ?>">Current <?= Source::getsourcename($other) ?> Issues <i class="fa fa-forward"></i></a>

                <?php }
                endif; ?>
                <div class="row">

                    <?php if (isset($active)) : ?>
                        <?php if ($active != 4) :

                        ?>
                            <div class="col-lg-12">
                                <div class="plan-index">
                                    <div id="ajaxCrudDatatable">
                                        <?php
                                        $fullExportMenu = ExportMenu::widget([
                                            'dataProvider' => $dataProvider,
                                            'columns' => require(__DIR__ . '/_columns.php'),
                                            'target' => ExportMenu::TARGET_BLANK,
                                            'fontAwesome' => true,
                                            'pjaxContainerId' => 'kv-pjax-container',
                                            'dropdownOptions' => [
                                                'label' => 'Export',
                                                'class' => 'btn btn-default',
                                                'itemsBefore' => [
                                                    '<li class="dropdown-header">Export All Data</li>',
                                                ],
                                            ],
                                        ]);
                                        ?>
                                        <?= GridView::widget([
                                            'id' => 'crud-datatable',
                                            'dataProvider' => $dataProvider,
                                            'filterModel' => $searchModel,
                                            'pjax' => false,

                                            'columns' => require(__DIR__ . '/_columns.php'),


                                            'toolbar' => [

                                                [
                                                    'content' => (User::isIAOfficer() && Globals::can('addIssue')  && Globals::myVote() && Globals::currentReportingDetail($source)) ? Html::a(
                                                        '<i class="glyphicon glyphicon-plus"></i> Add Findings (HOJA)',
                                                        ['create', 'source_id' => $source],
                                                        ['role' => 'modal-remote', 'title' => 'Add Findings (HOJA)', 'class' => 'btn btn-success']
                                                    ) : ""
                                                ],
                                            ],
                                            'striped' => true,
                                            'condensed' => true,
                                            'responsive' => true,
                                            'panel' => [
                                                'type' => 'default',
                                                'heading' => '<i class="glyphicon glyphicon-list"></i> observations / directives listing',
                                                'before' => '<em>* Resize table columns just like a spreadsheet by dragging the column edges.</em>',
                                                'after' => BulkButtonWidget::widget([
                                                    'buttons' => Html::a(
                                                        '<i class="glyphicon glyphicon-trash"></i>&nbsp; Remove All',
                                                        ["bulk-delete"],
                                                        [
                                                            "class" => "btn btn-danger btn-xs",
                                                            'role' => 'modal-remote-bulk',
                                                            'data-confirm' => false, 'data-method' => false, // for overide yii data api
                                                            'data-request-method' => 'post',
                                                            'data-confirm-title' => 'Are you sure?',
                                                            'data-confirm-message' => 'Are you sure want to delete this item'
                                                        ]
                                                    ),
                                                ]) .
                                                    '<div class="clearfix"></div>',
                                            ]
                                        ]) ?>
                                    </div>
                                </div>
                                <?php Modal::begin([
                                    "id" => "ajaxCrudModal",
                                    "footer" => "", // always need it for jquery plugin
                                ]) ?>
                                <?php Modal::end(); ?>
                            </div>
                        <?php endif ?>


                        <?php if (isset($active)) : if ($active == 4) : ?>

                                <div class="col-lg-12">
                                    <div class="reports-index">
                                        <div id="ajaxCrudDatatable">
                                            <?= GridView::widget([
                                                'id' => 'crud-datatable2',
                                                'dataProvider' => $dataProvider,
                                                'filterModel' => $searchModel,
                                                'pjax' => false,
                                                'columns' => require(__DIR__ . '/_iag_report_columns.php'),
                                                'toolbar' => [

                                                    [
                                                        'content' =>

                                                        '{toggleData}' .
                                                            '{export}'
                                                    ],
                                                ],
                                                'striped' => true,
                                                'condensed' => true,
                                                'responsive' => true,
                                                'panel' => [
                                                    'type' => 'default',
                                                    'heading' => '<i class="glyphicon glyphicon-list"></i> Reports uploaded',
                                                    'before' => '<em>* Resize table columns just like a spreadsheet by dragging the column edges.</em>',

                                                ]
                                            ]) ?>
                                        </div>
                                    </div>
                                    <?php Modal::begin([
                                        "id" => "ajaxCrudModal2",
                                        "footer" => "", // always need it for jquery plugin
                                    ]) ?>
                                    <?php Modal::end(); ?>
                                </div>
                        <?php endif;
                        endif; ?>

                    <?php endif; ?>
                </div>
                <!-- begin wizard step-1 -->

            </div>
        </div>
        <!-- end panel -->
    </div>