<?php

use yii\helpers\Url;
use yii\helpers\Html;
use common\models\Plan;
use common\helpers\Date;
use common\components\Globals;

?>

<div class="invoice">
    <span class="pull-right hidden-print">
        <a href="javascript:history.back()" class="btn btn-sm btn-primary m-b-10"><i class="fa fa-backward m-r-5"></i> Back </a>
    </span>
    <div class="invoice-company row">
        <div class="col-md-8">

            <b>PARA NO:</b> <?= $model->item_no ?> of <?= $model->paraYear ? $model->paraYear->code : "-" ?><br>
            <b>TITLE: </b><?= $model->title ?></br>
            <b>VOTE: </b><?= $model->vote->detail ?>
        </div>
        <div class="col-md-4">
            <div> Assigned To:<?= $model->assignedUser?$model->assignedUser->getPublicIdentity():'- Not set -' ?></div>
            <?php if (Yii::$app->user->can('assignIssue')) : ?>
                <a title="Assign" href="#" class="showModal btn  btn-small btn-success" data-size="large" data-title="Assign" data-url="<?= Url::to(['assign', 'id' => $model->id]); ?>">
                    <?= $model->assigned_user_id ? 'Re-assign' : 'Assign' ?>
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="invoice-content">
        <div class="row">
            <!-- begin col-12 -->

            <div class="col-md-12 ui-sortable">
                <!-- begin panel -->
                <div class="panel panel-info">

                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-10">

                                <div class="tab">
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 0]); ?>" aria-expanded="true">

                                        <button class="<?= $active == 0 ? 'active' : '' ?>">

                                            <span class="visible-xs">Tab 1</span>
                                            <span class="hidden-xs">Findings detail (Cause,Criteria,Condition & Implication)</span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 1]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 1 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 2</span>
                                            <span class="hidden-xs">Recommendations</span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 3]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 3 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 4</span>
                                            <span class="hidden-xs">Management Responses</span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 2]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 2 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 3</span>
                                            <span class="hidden-xs">Audit Comments</span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 7]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 7 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 3</span>
                                            <span class="hidden-xs">Audit Committee Comments</span>

                                        </button></a>
                                    <!--  <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 8]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 8 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 3</span>
                                            <span class="hidden-xs">Board Directives</span>

                                        </button></a> -->

                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 4]); ?>" aria-expanded="false">
                                        <button class="<?= $active == 4 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 4</span>
                                            <span class="hidden-xs">Action to be taken /intended remedial action </span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 5]); ?>" aria-expanded="false">

                                        <button class="<?= $active == 5 ? 'active' : '' ?>">
                                            <span class="visible-hidden-xs">Actions taken</span>

                                        </button></a>
                                    <a href="<?= Url::to(['/plan/view', 'id' => $model->id, 'active' => 6]); ?>" aria-expanded="false">

                                        <button class=" <?= $active == 6 ? 'active' : '' ?>">
                                            <span class="visible-xs">Tab 6</span>
                                            <span class="hidden-xs">OIAG Review Comments</span>

                                        </button></a>
                                </div>

                                <div class="tabcontent">
                                    <?php $count = 0;
                                    if ($items) {
                                    ?>
                                        <ul class="media-list media-list-with-divider">
                                            <?php foreach ($items as $item) :   $count++; ?>
                                                <li class="media media-sm">
                                                    <?php if ($active == 6) { ?>
                                                        <div class="media-body" style="padding-top:10px;">
                                                            <p class="m-b-5">
                                                                <?= $item->content; ?><?php if ($model->status != Plan::STATUS_IMPLEMENTED_VALUE  && Globals::isMine($item)) : ?>
                                                                <a title='Edit' href="#" class='showModal btn-small ' data-title='Edit <?= Plan::detailoption($active) ?>' data-url='<?= Url::to(['plan/edititem', 'id' => $item->id, 'active' => $active]) ?>'><i class="fa fa-pencil"></i>edit</a>
                                                            <?php endif; ?>
                                                            <br /> <i class="pull-right text-muted">Reviewed on <?= date('d-M-Y', $item->created_at) ?></i>
                                                            <br /> <i class="pull-right text-muted">By: <?= common\models\User::findOne(['id' => $item->created_by])->getPublicIdentity(); ?></i>
                                                            </p>

                                                        </div>
                                                    <?php } else { ?>
                                                        <div class="media-body">
                                                            <p class="m-b-5">
                                                                <?= $item->content; ?><?php if ($model->status != Plan::STATUS_IMPLEMENTED_VALUE && Globals::isMine($item)) : ?>
                                                                <a title='Edit' href="#" class='showModal btn-small ' data-title='Edit <?= Plan::detailoption($active) ?>' data-url='<?= Url::to(['plan/edititem', 'id' => $item->id, 'active' => $active]) ?>'><i class="fa fa-pencil"></i>edit</a>
                                                            <?php endif; ?> <br /><i class="pull-right text-muted">Entered on <?= date('d-M-Y', $item->created_at) ?></i>
                                                            <br /> <i class="pull-right text-muted">By: <?= common\models\User::findOne(['id' => $item->created_by])->getPublicIdentity() ?></i>
                                                            </p>

                                                        </div <?php } ?> </li>
                                                    <?php endforeach; ?>

                                        </ul>
                                    <?php } else { ?>
                                        <div class="alert alert-warning">nothing to display </div> <?php } ?>
                                    <?php if ($model->status != Plan::STATUS_IMPLEMENTED_VALUE) :
                                        $displayAddButton = true;
                                        if ($active == 6)
                                            $displayAddButton = Globals::can('uploadGeneralReport');
                                        elseif ($active == 5)
                                            $displayAddButton = $model->isAssigned();
                                    ?>

                                        <?php if ($displayAddButton) : ?>
                                            <a title='Add <?= Plan::detailoption($active) ?>' href="#" class='showModal btn  btn-small btn-success' data-title='Add <?= Plan::detailoption($active) ?>' data-url='<?= Url::to(['plan/add', 'id' => $model->id, 'active' => $active]) ?>'><i class='fa fa-plus'></i> <?= Plan::detailoption($active) ?></a>

                                        <?php
                                        endif; ?>
                                    <?php
                                    endif; ?>

                                </div>


                            </div>
                            <div class="col-md-2">
                                <div class="table-responsive">
                                    <table class="table">

                                        <tbody>

                                            <tr>
                                                <td>
                                                    <h5>Status <?php if (true) : ?>
                                                            <a title='View Change History' href="#" class='showModal btn-small ' data-title='Status change History' data-url='<?= Url::to(['plan/statushistory', 'id' => $model->id]) ?>'>History <i class="fa fa-history"></i></a>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <?= $model->statusname; ?>
                                                    <?php if ($model->status != Plan::STATUS_IMPLEMENTED_VALUE) : ?>
                                                        <a title='Change Status' href="#" class='showModal btn-small ' data-title='Change observation/directive Status' data-url='<?= Url::to(['plan/changestatus', 'id' => $model->id]) ?>'><i class="fa fa-pencil"></i>Change</a>
                                                    <?php endif; ?>

                                                </td>
                                                <td>



                                                </td>
                                            </tr>
                                            <tr> <?php if ($model->status == Plan::STATUS_IMPLEMENTED_VALUE) : ?>
                                                    <div class="tab-content">
                                                        <div class="media-body">
                                                            <h4>Implementation Evidence/ref</h4>
                                                            <p class="m-b-5">
                                                                <?= $model->evidence_implemented; ?>
                                                            </p>
                                                        </div>
                                                        </li>



                                                    </div>
                                            <tr>
                                            <?php endif; ?>
                                            <tr>
                                                <td>
                                                    <h5>Timeframe</h5><?= Date::toDateString($model->timeline); ?>
                                                    <?php if ($model->status != Plan::STATUS_IMPLEMENTED_VALUE) : ?>
                                                        <a title='Change Deadline date' href="#" class='showModal btn-small ' data-title='Change Issue Status' data-url='<?= Url::to(['plan/changedeadline', 'id' => $model->id]) ?>'><i class="fa fa-pencil"></i>Change</a>
                                                </td> <?php endif; ?>
                                            </td>
                                            <td>

                                </div>

                                </tr>
                                <tr>
                                    <td>
                                        <h5>Term Length</h5> <b style="color: gray; font-weight:bold;"><?= $model->termlength; ?>
                                        </b>
                                    </td>
                                    <td><br /> </td>
                                </tr>

                                </tbody>
                                </table>


                            </div>


                        </div>
                    </div>
                </div>
            </div>
            <!-- end panel -->
        </div>
        <!-- end col-12 -->
    </div>
</div>

</div>