<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use common\helpers\Date;
use kartik\switchinput\SwitchInput;
use common\models\FinancialYear;
use common\models\Quarter;
/* @var $this yii\web\View */
/* @var $model common\models\Quarter */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="quarter-form">

    <?php $form = ActiveForm::begin(); ?>
 
    <?= $form->field($model, 'financial_year_id')->dropDownList(ArrayHelper::map(FinancialYear::all(), 'id', 'code'),['prompt'=>'select Financial Year']) ?>

    
    <?= $form->field($model, 'code')->dropDownList(ArrayHelper::map(Quarter::choices(), 'value', 'name'),['prompt'=>'Select Code']) ?>

  <label class="control-label">Start date</label>
    <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'initial_date', 	
	'options' => ['placeholder' => 'Select start date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
   <label class="control-label">End Date</label>
      <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'final_date',  	
	'options' => ['placeholder' => 'Select end date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
    
  <?= $form->field($model, 'is_current')->widget(SwitchInput::classname(), [
    'type' => SwitchInput::CHECKBOX
]);?>
    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
