<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\search\Quarter */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Quarters';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="quarter-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Quarter', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'name',
            'code',
             [
                'header'=>'Start Date',
                 'value' => function($model) {
                   return $model->initial_date;
                },
            ],
                         [
                'header'=>'End Date',
                 'value' => function($model) {
                   return $model->final_date;
                },
            ],
            
             [
                'attribute' => 'is_current',
                'format' => 'raw',
                'filter' => [1 => 'Active', 0 => 'Not Active'],
                'value' => function($model) {
                    
                    $class= $model->is_current?"label-success":"label-default";
                    $value= $model->is_current?"Active":"Not Active";
                    return "<label class='label $class'>$value</label>";
                },
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
