<?php
use yii\helpers\Url;
use common\models\search\Category;
use common\models\Vote;
use common\models\FinancialYear;
use yii\helpers\Html; 
use common\models\User;
use common\components\Globals;
use common\models\ReportingDetail;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Quarter;
return [
   [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'type',
         'format' => 'raw',
         'filter'=>\yii\helpers\ArrayHelper::map(ReportingDetail ::cagReportOptions(), 'id', 'name'),          
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
       'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return ReportingDetail::cagReportType($model->type);
         },
    ],
  
    
      
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'financial_year_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->financialYear?$model->financialYear->code:"-";
         },
    ],
               
                         [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-download'></i>";
                      $linkUrl = $model->filepath;  
    
                      $result=Html::a("$icon Download",Url::to(['/report-detail/downloadcag','file'=>$linkUrl]),['title'=>'Download','target'=>'_blank']);
                      
                     return $result;
                     
                     
                     },
     ],
   
       /**           [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = !$model->observations?"<i class='fa fa-plus'></i>":"";
                      $linkUrl = ['/plan/view','id'=>$model->id];                 
                      $result=Html::a("$icon Details",$linkUrl,array('title'=>'View Details', ));
                      
                     return $result;
                     
                     
                     },
     ], ****/
   
   

];   