<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\FinancialYear;
use common\models\Quarter;
use common\models\Source;
use common\models\Vote;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use kartik\depdrop\DepDrop;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model common\models\ReportingDetail */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="reporting-detail-form">

    <?php $form = ActiveForm::begin(); ?>
    <?= $form->field($model, 'source_id')->dropDownList(ArrayHelper::map(Source::all(), 'id', 'code'),['prompt'=>'Select Type']) ?>
    <?php
        
        $years= FinancialYear::all();
          $listData=ArrayHelper::map($years,'id','code'); 
        echo $form->field($model, 'financial_year_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...','id'=>'year_id'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
   <?=
           $form->field($model, 'quarter_id')->widget(DepDrop::classname(), [
     'options' => ['id'=>'quarter-id'],
     'pluginOptions'=>[
         'depends'=>['year_id'],
         'placeholder' => 'Select...',
         'url' => Url::to(['/quarter/list'])
     ]
 ]);
            
           ?>

      <?php
        
        $votes= Vote::find()->all();
          $listData=ArrayHelper::map($votes,'id','name'); 
        echo $form->field($model, 'vote_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>

    <?//= $form->field($model, 'submitted')->textInput() ?>

    <? //= $form->field($model, 'confirmed')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Save' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
