<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use common\helpers\Date;
use kartik\switchinput\SwitchInput;
use common\models\FinancialYear;
use common\models\Quarter;
use kartik\select2\Select2;
use kartik\depdrop\DepDrop;
use common\models\ReportingDetail;
use yii\helpers\Url;
/* @var $this yii\web\View */
/* @var $model common\models\ReportNotice */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="report-notice-form">

    <?php $form = ActiveForm::begin(); ?>
<div class="col-md-6">
                                <?php
        
        $types= ReportingDetail::iagReportOptions();
          $listData=ArrayHelper::map($types,'id','name'); 
        echo $form->field($model, 'report_type')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...','class'=>'form-control','id'=>'reporttype'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>   
                                </div>

                        
<div class="col-md-6">
            <?php
        
        $years= FinancialYear::all();
          $listData=ArrayHelper::map($years,'id','code'); 
        echo $form->field($model, 'financial_year_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...','id'=>'year_id','class'=>'form-control'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
    </div>
          <div class="col-md-6">
   <?=
           $form->field($model, 'quarter_id')->widget(DepDrop::classname(), [
     'options' => ['id'=>'quarter-id','class'=>'form-control'],
     'pluginOptions'=>[
         'depends'=>['year_id'],
         'placeholder' => 'Select...',
         'url' => Url::to(['/quarter/list'])
     ]
 ]);
            
           ?></div>
                            <div class="col-md-6">
                                 <label >Publish Start date</label>
    <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'initial_date', 	
	'options' => ['placeholder' => 'Select start date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
                            </div>
                            <div class="col-md-6">
   <label >Publish End Date</label>
      <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'final_date',  	
	'options' => ['placeholder' => 'Select end date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
                            </div>
                            <div class="col-md-6">
   <label >Report Deadline</label>
      <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'due_date_deadline',  	
	'options' => ['placeholder' => 'Select Deadline'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
                            </div>

  
	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>






    <div class="col-md-6"></div>
                            

                  