<?php
use yii\helpers\Url;
use common\components\Globals;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Auditor;

return [
   
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    
   
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'fullname',
    ],
                 [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'gender',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(Auditor::genderoptions(), 'id', 'name'),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->genderName;
         },
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'phone_number',
    ],
                  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'email',
    ],
                  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(Globals::allVotes(), 'id', 'name'),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'title_position',
    ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'phone_number',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'email',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'gender',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'data_of_birth',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'check_no',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'date_of_appointment',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'highest_qualification',
    // ],
    

];   