<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\FinancialYear;
use common\models\Quarter;
use common\components\Globals;
use common\models\Vote;
use kartik\select2\Select2;
use kartik\depdrop\DepDrop;
use yii\helpers\Url;
use common\models\ReportingDetail;
$this->title = 'Upload Review Feedback';

?>
<div class="col-md-12 ui-sortable">
			        <!-- begin panel -->
                    <div class="panel panel-info">
                        <div class="panel-heading">
                           
                           <h4 class="panel-title">Upload Reviews</h4>
                           
                        </div>
                          <span class="pull-right hidden-print">
                              <a href="<?= Url::to(['/review-feedback']) ?>"  class="btn btn-sm btn-primary m-b-10"><i class="fa fa-backward m-r-5"></i> Back </a>
               </span>
                        
                       <div class="panel-body">
                            <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]) ?>
                           
                            <div class="col-md-6">
 <?= $form->field($model, 'file')->fileInput(['class'=>'form-control']) ?>
                                </div>
                                      <div class="col-md-6">
 <?php
        
        $votes= Globals::myVotes();
          $listData=ArrayHelper::map($votes,'id','name'); 
        echo $form->field($model, 'vote_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>  </div>
<div class="col-md-6">
            <?php
        
        $years= FinancialYear::all();
          $listData=ArrayHelper::map($years,'id','code'); 
        echo $form->field($model, 'financial_year_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...','id'=>'year_id','class'=>'form-control'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
    </div>
                            <div class="col-md-6">
   <?=
           $form->field($model, 'quarter_id')->widget(DepDrop::classname(), [
     'options' => ['id'=>'quarter-id','class'=>'form-control'],
     'pluginOptions'=>[
         'depends'=>['year_id'],
         'placeholder' => 'Select...',
         'url' => Url::to(['/quarter/list'])
     ]
 ]);
            
           ?></div>

                            <div class="col-md-6">
 <?= $form->field($model, 'description')->input(['class'=>'form-control']) ?>
                                </div>
               
                           <div class="col-md-6">
                               
  <div class="col-md-6">
     <?php
        
        $items = [['id'=>'1','name'=>'Yes'],['id'=>0,'name'=>'No']];
          $listData=ArrayHelper::map($items,'id','name'); 
        echo $form->field($model, 'published')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['id'=>'itemrid'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
    </div>                        </div>
                            <div class="form-group">
        <?= Html::submitButton('Upload Now' , ['class' => 'btn btn-success pull-right']) ?>
    </div>

    <?php ActiveForm::end(); ?>
                        </div>
                    </div>
</div>
                                