<?php
use yii\helpers\Url;
use yii\helpers\Html; 
use kartik\grid\GridView;
use common\helpers\Date;
use common\components\Globals;
return [
    
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
   
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'name',
    ],
              [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-download'></i>";
                      $linkUrl = $model->filename;  
                      $visible = true; //Globals::can('unpublishPublicDocs');
                      $result=($visible && $model->published)?Html::a("$icon Download",Url::to(['/shared-document/download','file'=>$linkUrl]),['title'=>'Download','target'=>'_blank']):"";
                      
                     return $result;
                     
                     
                     },
     ],
  
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'created_at',
      
        
        'value'=>
                     function($model) {
                    
                     return Date::toDateString ($model->created_at);
                     
                     
                     },
    ],
  
       [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-pencil'></i>";
                      $linkUrl = $model->filename;  
                        $visible = Globals::can('unpublishPublicDocs');
                      $result=$visible?Html::a("$icon Edit",Url::to(['/shared-document/updateupload','id'=>$model->id]),['title'=>'Edit']):"";
                      
                     return $result;
                     
                     
                     },
     ],

];   