<?php

use common\models\Source;
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Vote;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use common\components\Globals;
use common\models\FinancialYear;
use common\models\ReportingDetail;
use kartik\depdrop\DepDrop;
use common\models\User;
$this->title = "Welcome GARI-ITS";
?>
<!-- begin row -->
<div class="row">
    <div class="col-md-12">
       <?php if(common\models\User::isIAOfficer()):
                 $vote =  \common\components\Globals::myVote();
                 $name = $vote?$vote->name." - Vote No: ".$vote->code:"But, You're not assigned any vote"; 
                 ?> <h4 class="center-block"><b>Welcome in:  </b><?= $name; ?></h4>
                     <?php
             endif;
             ?>   </div>
    <!-- begin col-3 -->
    <?php
    $sources = Source::allCore();
    $sourcesother = Source::allOtherAudit();
    foreach ($sources as $source):
        if(($source->id==1 && Globals::can('accessIAGArea')) || ($source->id==2 && Globals::can('accessCAGArea'))):
        ?>
        
        <div class="col-md-3 col-sm-6">
            <div class="widget widget-stats bg-green">
                <div class="stats-icon"><i class="fa fa-database"></i></div>
                <div class="stats-info">
                    <h4><?= $source->name; ?></h4>
                    <p><?= $source->code; ?> Area</p>	
                </div>

                <div class="stats-link">
                        <?php 
                        $url = Url::to(['/plan/index', 'source' => $source->id,'active'=>3]);
                        if($source->id==2)
                        $url = Url::to(['/plan/cag'])?>
                      <a title="Enter <?= $source->code; ?> area" href="<?= $url; ?>">Enter <i class="fa fa-arrow-circle-o-right"></i></a>
                </div>
            </div>
        </div>
    

        <!-- end col-3 -->
<?php endif;  endforeach; ?>
        <?php if((Globals::can('accessOtherAudit'))):?>
    <form method="GET" action="<?= Url::to(['/plan/index'])?>"> 
        <div class="col-md-3 col-sm-6">
            <div class="widget widget-stats bg-green">
                <div class="stats-icon"></div>
                <div class="stats-info">
                    <h4>Other oversights </h4>
                     <?php  echo Html::hiddenInput('active', 3);?>
                   <?= Html::dropDownList('source', null,
      ArrayHelper::map($sourcesother, 'id', 'name'),['class'=>'form-control']) ?>	
                </div>

                <div class="stats-link">
                        <?php 
                        $url = Url::to(['/plan/index', 'source' => 1,'active'=>4]);
                      ?>
                     
                    <div class="front-enter" >
                       <?php echo Html::submitButton(Yii::t('frontend', 'Enter Area').' <i class="fa fa-arrow-circle-o-right"></i>', ['class' => 'front-button']) ?>
              
                    </div>
                </div>
            </div>
        </div>
        
        <?php endif;?>
    <!-- end col-3 -->
    <?php if((Globals::can('accessUploadReports') && User::isIAOfficer()) ):?>
 <div class="col-md-3 col-sm-6">
            <div class="widget widget-stats bg-green">
                <div class="stats-icon"><i class="fa  <?= User::isIAOfficer()?"fa-file-pdf-o":"fa-file-pdf-o"?>"></i></div>
                <div class="stats-info">
                    <h4><?= User::isIAOfficer()?"My submitted":"All Reports"?></h4>
                   <p>Outputs</p>	
                </div>
                   report-detail/report-index
                <div class="stats-link">
                        <?php 
                        $url = Url::to(['/plan/index', 'source' => 1,'active'=>4]);
                      ?>
                      <a title="<?= User::isIAOfficer()?'View My submitted Reports':'View All Uploaded Reports'?>" href="<?= $url; ?>">Enter  Reports <i class="fa fa-arrow-circle-o-right"></i></a>
                </div>
            </div>
        </div>
    <?php endif; ?>
     <?php if(Globals::can('accessReports')):?>
 <div class="col-md-3 col-sm-6">
            <div class="widget widget-stats bg-green">
                <div class="stats-icon"><i class="fa fa-file-pdf-o"></i></div>
                <div class="stats-info">
                    <h4>Report Area</h4>
                   <p>Outputs</p>	
                </div>
                   
                <div class="stats-link">
                        <?php 
                        $url = Url::to(['report-detail/report-index']);
                      ?>
                      <a title="View Reports" href="<?= $url; ?>">Enter  Reports <i class="fa fa-arrow-circle-o-right"></i></a>
                </div>
            </div>
        </div>
    <?php endif; ?>
     </form>
</div>
<!-- end row -->
<!-- begin row -->
<div class="row">
    <!-- begin col-8 -->
    <?php if(Globals::can('viewIssueSummary')):?>
    <div class="col-md-8">
        <div class="panel panel-info" data-sortable-id="index-1">
            <div class="panel-heading">

                <h4 class="panel-title">Observations Reported by (<?= Globals::currentYear()->code; ?>)</h4>
            </div>
            <div class="panel-body">
                <?php
                $form = ActiveForm::begin(['id' => 'dashboard-form',
                            'options' => [
                                
                            ]
                ]);
                ?>
                <div class="col-md-12">
                <div class="row form-group col-md-3">
                    <?php
                    $sources = Source::all();
                    $listData = ArrayHelper::map($sources, 'id', 'name');
                    echo $form->field($model, 'source_id')->widget(Select2::classname(), [
                        'data' => $listData,
                        'language' => 'en',
                        'options' => ['placeholder' => '--All--', 'class' => 'form-control'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]);
                    ?>
                </div>
                <div class="row form-group col-md-3">
                    <?php
                    $votes = Globals::myVotes();
                    $listData = ArrayHelper::map($votes, 'id', 'name');
                    echo $form->field($model, 'vote_id')->widget(Select2::classname(), [
                        'data' => $listData,
                        'language' => 'en',
                        'options' => ['placeholder' => '--All--', 'class' => 'form-control'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]);
                    ?>
                </div>
                <div class="row form-group col-md-3">
                    <?php
                    $years = FinancialYear::all();
                    $listData = ArrayHelper::map($years, 'id', 'code');
                    echo $form->field($model, 'year_start_id')->widget(Select2::classname(), [
                        'data' => $listData,
                        'language' => 'en',
                        'options' => ['placeholder' => '--All--', 'class' => 'form-control'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]);
                    ?>
                </div>
                     <div class="row form-group col-md-3">
                    <?php
                    $years = FinancialYear::all();
                    $listData = ArrayHelper::map($years, 'id', 'code');
                    echo $form->field($model, 'year_end_id')->widget(Select2::classname(), [
                        'data' => $listData,
                        'language' => 'en',
                        'options' => ['placeholder' => '--All--', 'class' => 'form-control'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]);
                    ?>
                </div>
                         <?php echo Html::submitButton(Yii::t('frontend', 'Go'), ['class' => 'row pull-right col-md-1 btn btn-primary', 'style'=>'margin-top:20px', 'name' => 'contact-button']) ?>
<!--<a href="javascript:;" class="btn btn-sm btn-success"><i class="fa fa-download m-r-5"></i>PDF</a> -->	

                </div>
               
           

                <div class="col-md-6 col-sm-6">
                    <div class="widget widget-stats bg-grey-darker">
                        <div class="stats-icon"><?= $dashboard['total'] ?></div>
                        <div class="stats-info">
                            <h4>Total issues</h4>
                            <p>All issues</p>	
                        </div>

                    </div>
                </div>
                 <?php $implemented= number_format($dashboard['implemented'])?>
                <a href="<?= Url::to(['/plan/detailed-issues','status'=> common\models\Plan::STATUS_IMPLEMENTED_VALUE,'title'=>'Issues Implemented',
                   'Plan'=>['vote_id'=>$model->vote_id,'source_id'=>$model->source_id,  'status'=> common\models\Plan::STATUS_IMPLEMENTED_VALUE]])?>"/>
                
                <div class="col-md-6 col-sm-6">
                    <div class="widget widget-stats bg-green-darker">
                        <div class="stats-icon"><?= $implemented ?></div>
                        <div class="stats-info">
                            <h4>Issues completed</h4>
                            <p>IMPLEMENTED</p>	
                        </div>

                    </div>
                </div>
                  <?php $inprogress= number_format($dashboard['inprogress'])?>
                <a href="<?= Url::to(['/plan/detailed-issues','status'=> common\models\Plan::STATUS_INPROGRESS_VALUE,'title'=>'In Progress ',
                    'previous'=>'',
                   'Plan'=>['vote_id'=>$model->vote_id,'source_id'=>$model->source_id,  'status'=> common\models\Plan::STATUS_INPROGRESS_VALUE]])?>"/>
                
               
                <div class="col-md-6 col-sm-6">
                    <div class="widget widget-stats bg-blue">
                        <div class="stats-icon"><?= $inprogress ?></div>
                        <div class="stats-info">
                            <h4>Started</h4>
                            <p>IN PROGRESS</p>
                           	
                        </div>

                    </div>
                </div>
                </a>
                <?php $nonimplemented= number_format($dashboard['total'] - $dashboard['implemented'])?>
                <a href="<?= Url::to(['/plan/detailed-issues','status'=> common\models\Plan::STATUS_NOT_IMPLEMENTED_VALUE,'title'=>'Not closed',
                   'Plan'=>['vote_id'=>$model->vote_id,'source_id'=>$model->source_id,'status'=> common\models\Plan::STATUS_NOT_IMPLEMENTED_VALUE]])?>"/>
                <div class="col-md-6 col-sm-6">
                    <div class="widget widget-stats bg-red">
                        <div class="stats-icon"><?= $nonimplemented ?></div>
                        <div class="stats-info">
                            	 <h4>outstanding</h4>
                            <p>NOT CLOSED</p>
                        </div>

                    </div>
                </div>
                </a>
               
                
                <?php ActiveForm::end(); ?>
            </div>
        </div>

    </div>
    <?php endif; ?>
  
    <!-- end col-4 -->
    
    <div class="col-md-4">
        <?php if(Globals::can('accessQuickLinks')):?>
    
         
        <div class="panel panel-info"> 
        <div class="panel-heading">

                <h4 class="panel-title">Quick Access
               
                </h4>
                   </div>
             
        <div class="tab-content">
           <div id="wizard" class="bwizard clearfix">
                                   
                                   
								<ul class="forum-list">
                    
                    
                                                                     
                       
                     <div class="row">
                         
                         <?php if(Globals::can('addIssue')):?>
                         <a href="<?= Url::to(['/plan/index', 'source' => 1,'active'=>3])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                            <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-plus"></i>  Add HOJA ( Observation /Directive )</h5>
                                
                            </div>
                           
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif;?>
                         <?php if(Globals::can('sendVoteReport')):?>
                         <a href="<?= Url::to(['/report-detail/uploadvote'])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                            <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-send"></i>  Send Report</h5>
                                
                            </div>
                           
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif;?>
                               <?php if(Globals::can('searchIssue')):?>
                         <a href="<?= Url::to(['/reports/issue-search'])?>">
                        
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                           
                             <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-search"></i>  Find HOJA (observation /directive)</h5>
                                
                            </div>
                          
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif; ?>
                         <?php if(Globals::can('accessManagementLetters')):?>
                         <a href="<?= Url::to(['/plan/index', 'source' => 1,'active'=>4])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                           
                             <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-file-pdf-o"></i> Attached Reports</h5>
                                
                            </div>
                          
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif; ?>
                          <?php if(Globals::can('accessAuditors')):?>
                         <a href="<?= Url::to(['/auditor'])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                           
                             <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-user"></i>  Find Internal Auditors</h5>
                                
                            </div>
                          
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif; ?>
                           <?php if(Globals::can('accessHqAuditors')):?>
                         <a href="<?= Url::to(['/auditor/hq'])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                           
                             <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-users"></i>  HQ Internal Auditors</h5>
                                
                            </div>
                          
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif; ?>
                          <?php if(Globals::can('accessPublicDocs')):?>
                         <a href="<?= Url::to(['/shared-document'])?>">
                        <li class="col-md-12">
                       <!-- end media -->
                        <!-- begin info-container -->
                        <div class="info-container">
                           
                             <div class="info quick-item">
                                <h5 class="title"><i class="fa fa-1x fa-download"></i> Shared Documents</h5>
                                
                            </div>
                          
                        </div>
                        <!-- end info-container -->
                        </li></a>
                         <?php endif; ?>
                     
                       </div>
                       
                      
                        
                    
                </ul>
									<!-- begin wizard step-1 -->
							
                        </div>
        
        </div>
        
    </div>
        <?php endif;?>
       <?php if(Globals::can('viewReportSubmission')):?>
    
        
         <?php $form = ActiveForm::begin(['id' => 'report-form', 'class' => 'col-md-12 form-inline']); ?>
           
        <div class="panel panel-info"> 
        <div class="panel-heading">

                <h4 class="panel-title">Summary Reports 
               
                </h4>
                   </div>
             
        <div class="tab-content">
             <?= $form->field($model_report, 'submitted')->dropDownList(
            ['1' => 'Submitted Reports', '2' => 'Reports Not Submitted']
              ); ?>
            <div class="row">       
            <div class="form-group col-md-12">                  
                <?php
                $types = ReportingDetail::iagReportOptions();
                $listData = ArrayHelper::map($types, 'id', 'name');
                echo $form->field($model_report, 'report_type')->widget(Select2::classname(), [
                    'data' => $listData,
                    'language' => 'en',
                    'options' => ['placeholder' => '--Select--', 'class' => 'form-control', 'id' => 'type_report'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]);
                ?>
            </div>
            
            </div>
            <div class="row">  
            <div class="form-group col-md-5">
                    <?php
                    $years = FinancialYear::all();
                    $listData = ArrayHelper::map($years, 'id', 'code');
                    echo $form->field($model_report, 'report_financial_year_id')->widget(Select2::classname(), [
                        'data' => $listData,
                        'language' => 'en',
                        'options' => ['placeholder' => '--All--', 'class' => 'form-control','id'=>'financial_year_id_report'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]);
                    ?>
                </div>
            <div class="form-group col-md-5">
    <?=
           $form->field($model_report, 'report_quarter_id')->widget(DepDrop::classname(), [
     'options' => [],
     'pluginOptions'=>[
         'depends'=>['financial_year_id_report'],
         'placeholder' => 'Select...',
         'url' => Url::to(['/quarter/list'])
     ]
 ]);
            
           ?>
            </div>
            <div class="form-group col-md-2">
                           <?php echo Html::submitButton(Yii::t('frontend', 'Go'), ['class' => 'pull-right btn btn-primary', 'style'=>'margin-top:22px',  'name' => 'contact-button']) ?>
<!--<a href="javascript:;" class="btn btn-sm btn-success"><i class="fa fa-download m-r-5"></i>PDF</a> -->	
           
  </div>
            </div>
            <div class="row"> 
            
            <div class="help-block">
                    <div class="widget widget-stats bg-green-darker">
                        <div class="stats-icon"><?= $report_count;?></div>
                        <div class="stats-info">
                           <?php if($model_report->submitted==2){ ?>
                            <p>Not submitted</p>
                           <?php }else{?>
                            <p>Submitted</p>
                           <?php }?>
                        </div>

                    </div>
                </div>
                </div>
        
        </div>
        <?php ActiveForm::end(); ?>
    </div>
        <?php endif; ?>
         </div>
    
    
</div>
<!-- end row -->