# How to contribute

At Codeception we are glad to receive contributions and patches from the community. There are a few guidelines that we need contributors to follow so that we can have a chance of keeping on top of things.

Please check the guide for sending your contributions with Github at https://github.com/Codeception/Codeception/wiki/Git-workflow-for-Codeception-contributors

## Coding Standards
All contributions must follow the coding standards described at: https://github.com/Codeception/Codeception/wiki/Codeception-coding-style-standard

## Code
**Bugfixes should be sent to to current stable branch, which is the same as major version number.**

Breaking features and major improvements should be sent into `master`. When you send PRs to master, they will be added to release cycle only when the next stable branch is started.

Check also the "tests/README.md" to learn more about the available internal Codeception tests.

## Documentation

### Guides
If you want to contribute documentation to the guides you are asked to send your changes to the /docs/ folder: https://github.com/Codeception/Codeception/tree/2.0/docs. This files are the source for the codeception website guides: http://codeception.com/docs/01-Introduction. Remind to send your documentation improvements to the right "repository branch" depending on the Codeception version you are working with: 2.0, master,...

### Modules Documentation
The documentation for each module is directly generated from the corresponding docblock which can be found in each module (src/Module/Codeception/*.php).