


Works with MongoDb database.

The most important function of this module is cleaning database before each test.
To have your database properly cleaned you should configure it to access the database.

In order to have your database populated with data you need a valid js file with data (of the same style which can be fed up to mongo binary)
File can be generated by RockMongo export command
Just put it in ``` tests/_data ``` dir (by default) and specify path to it in config.
Next time after database is cleared all your data will be restored from dump.
The DB preparation should as following:
- clean database
- system collection system.users should contain the user which will be authenticated while script performs DB operations

Connection is done by MongoDb driver, which is stored in Codeception\Lib\Driver namespace.
Check out the driver if you get problems loading dumps and cleaning databases.

## Status

* Maintainer: **judgedim**, **davert**
* Stability: **beta**
* Contact: codecept@davert.mail.ua

*Please review the code of non-stable modules and provide patches if you have issues.*

## Config

* dsn *required* - MongoDb DSN with the db name specified at the end of the host after slash
* user *required* - user to access database
* password *required* - password
* dump - path to database dump
* populate: true - should the dump be loaded before test suite is started.
* cleanup: true - should the dump be reloaded after each test



### dontSeeInCollection
 
Checks if collection doesn't contain an item.

``` php
<?php
$I->dontSeeInCollection('users', array('name' => 'miles'));
```

 * `param` $collection
 * `param array` $criteria


### grabCollectionCount
 
Grabs the documents count from a collection

``` php
<?php
$count = $I->grabCollectionCount('users');
// or
$count = $I->grabCollectionCount('users', array('isAdmin' => true));
```

 * `param` $collection
 * `param array` $criteria
 * `return` integer


### grabFromCollection
 
Grabs a data from collection

``` php
<?php
$cursor = $I->grabFromCollection('users', array('name' => 'miles'));
```

 * `param` $collection
 * `param array` $criteria
 * `return` \MongoCursor


### haveInCollection
 
Inserts data into collection

``` php
<?php
$I->haveInCollection('users', array('name' => 'John', 'email' => 'john * `coltrane.com'));` 
$user_id = $I->haveInCollection('users', array('email' => 'john * `coltrane.com'));` 
```

 * `param` $collection
 * `param array` $data


### seeElementIsArray
 
Asserts that an element in a collection exists and is an Array

``` php
<?php
$I->seeElementIsArray('users', array('name' => 'John Doe') , 'data.skills');
```

 * `param String` $collection
 * `param Array` $criteria
 * `param String` $elementToCheck


### seeElementIsObject
 
Asserts that an element in a collection exists and is an Object

``` php
<?php
$I->seeElementIsObject('users', array('name' => 'John Doe') , 'data');
```

 * `param String` $collection
 * `param Array` $criteria
 * `param String` $elementToCheck


### seeInCollection
 
Checks if collection contains an item.

``` php
<?php
$I->seeInCollection('users', array('name' => 'miles'));
```

 * `param` $collection
 * `param array` $criteria


### seeNumElementsInCollection
 
Count number of records in a collection

``` php
<?php
$I->seeNumElementsInCollection('users', 2);
$I->seeNumElementsInCollection('users', 1, array('name' => 'miles'));
```

 * `param` $collection
 * `param integer` $expected
 * `param array` $criteria


### useDatabase
 
Specify the database to use

``` php
<?php
$I->useDatabase('db_1');
```

 * `param` $dbName

<p>&nbsp;</p><div class="alert alert-warning">Module reference is taken from the source code. <a href="https://github.com/Codeception/Codeception/tree/2.1/src/Codeception/Module/MongoDb.php">Help us to improve documentation. Edit module reference</a></div>
