<?php
namespace backend\models;

use common\models\User;
use yii\base\Exception;
use yii\base\Model;
use Yii;
use yii\helpers\ArrayHelper;
use common\models\UserVote;
use common\helpers\Date;


/**
 * Create user form
 */
class UserForm extends Model
{
    public $username;
    public $email;
    public $password;
    public $status;
    public $type;
    public $roles;
    
    public $votes;
    private $model;
    public $voteid;
    public $initial_date;
    public $final_date;
    const  DAY_SECONDS =   86400;
    public $expire;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            ['username', 'filter', 'filter' => 'trim'],
            [['username','email'], 'required'],
            ['type', 'required'],
            [['votes','voteid'], 'safe'],
            ['username', 'unique', 'targetClass' => User::className(), 'filter' => function ($query) {
                if (!$this->getModel()->isNewRecord) {
                    $query->andWhere(['not', ['id'=>$this->getModel()->id]]);
                }
            }],
            ['username', 'string', 'min' => 2, 'max' => 255],
                    [['initial_date','final_date'], 'string', 'max' => 255],
                    //[['initial_date','final_date'], 'default', 'value' => ''],

            ['email', 'filter', 'filter' => 'trim'],
           //mail', 'required'],
            ['email', 'email'],
            ['email', 'unique', 'targetClass'=> User::className(), 'filter' => function ($query) {
                if (!$this->getModel()->isNewRecord) {
                    $query->andWhere(['not', ['id'=>$this->getModel()->id]]);
                }
            }],

            ['password', 'required', 'on' => 'create'],
            ['password', 'string', 'min' => 6],

            [['status','expire'], 'integer'],
            [['type'], 'integer'],
                    [['initial_date'], 'validateDateStart'],
                    [['final_date'], 'validateDateEnd'],
          
            [['roles'], 'each',
                'rule' => ['in', 'range' => ArrayHelper::getColumn(
                    Yii::$app->authManager->getRoles(),
                    'name'
                )]
            ],
        ];
    }
  public function validateDateStart($attribute, $params, $validator)
    {
      if($this->expire == User::PASSWORD_EXPIRE_YES){
         if(Date::toTimestamp ($this->initial_date) > Date::toTimestamp ($this->final_date))
             $this->addError($attribute, 'Must be less than End Date');
       if(Date::toTimestamp ($this->initial_date)  < time() - self::DAY_SECONDS)
             $this->addError($attribute, 'Can not assign previous dates');
      }
    }
    public function validateDateEnd($attribute, $params, $validator)
    {
        if($this->expire == User::PASSWORD_EXPIRE_YES){ 
        if(Date::toTimestamp ($this->initial_date) > Date::toTimestamp ($this->final_date))
             $this->addError($attribute, 'Must be greater than Start Date');
       if(Date::toTimestamp ($this->final_date)  < time() - self::DAY_SECONDS)
             $this->addError($attribute, 'Can not assign previous dates');
        }
    }
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'username' => Yii::t('common', 'Username'),
            'email' => Yii::t('common', 'Email'),
            'status' => Yii::t('common', 'Status'),
             'votes'=>Yii::t('common', 'Assigned Votes'),
            'password' => Yii::t('common', 'Password'),
            'roles' => Yii::t('common', 'Roles'),
            'expire'=>Yii::t('common', 'Password Expiry ?'),
            'initial_date' => 'Password Valid From (option)',
            'final_date' => 'Password End Date (option)',
            
        ];
    }

    /**
     * @param User $model
     * @return mixed
     */
    public function setModel($model)
    {
        $this->username = $model->username;
        $this->email = $model->email;
        $this->status = $model->status;
        $this->model = $model;
        $this->votes = $model->votes;
        $this->type = $model->type;
        $this->expire = $model->password_expire;
        //set default dates
        //one day = 3600*24 = 86400
        
        if(!$model->start_date)
            $model->start_date = time();
        if(!$model->end_date)
            $model->end_date= time() + self::DAY_SECONDS; 
        $this->initial_date = Date::toDateString ($model->start_date);
        $this->final_date = Date::toDateString ($model->end_date);
       
        $this->roles = ArrayHelper::getColumn(
            Yii::$app->authManager->getRolesByUser($model->getId()),
            'name'
        );
        return $this->model;
    }

    /**
     * @return User
     */
    public function getModel()
    {
        if (!$this->model) {
            $this->model = new User();
        }
        return $this->model;
    }
  
    /**
     * Signs user up.
     * @return User|null the saved model or null if saving fails
     * @throws Exception
     */
    
    public function save()
    {
        if ($this->validate()) {
            $model = $this->getModel();
            $isNewRecord = $model->getIsNewRecord();
            $model->username = $this->username;
            $model->email = $this->email;
            $model->status = $this->status;
            $model->type = $this->type;
            //set expiry dates
            $model->start_date = Date::toTimestamp ($this->initial_date);
            $model->end_date =Date::toTimestamp ($this->final_date);
           $model->password_expire = $this->expire;
            //assign vote
            
            
            if ($this->password) {
                $model->setPassword($this->password);
            }
            if (!$model->save()) {
                //print_r($model->errors); exit;
                throw new Exception('Model not saved');
            }
            
            
            //find vote assignment
            if($this->voteid){
                
                $uservote = new UserVote ();
               $uservote->user_id = $model->id;
               $uservote->vote_id = $this->voteid;
            
             $uservote->save();
               
            }
            
            //find vote assignment
            if($this->votes){
                //delete previous assignments
            $uservote = UserVote::deleteAll([
                'user_id' => $model->id,     
            ]); 
           
             foreach($this->votes as $vote):
                $uservote = new UserVote ();
               $uservote->user_id = $model->id;
               $uservote->vote_id = $vote;
            
             $uservote->save();
                 
             endforeach;
            }
            /** end vote assignment **/
            
            if ($isNewRecord) {
                $model->afterSignup();
            }
            $auth = Yii::$app->authManager;
            $auth->revokeAll($model->getId());

            if ($this->roles && is_array($this->roles)) {
                foreach ($this->roles as $role) {
                    $auth->assign($auth->getRole($role), $model->getId());
                }
            }

            return $model;
        }
        return null;
    }
     
    
}
