<?php

namespace backend\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;

/**
 * UserSearch represents the model behind the search form about `common\models\User`.
 */
class UserSearch extends User {

    public $first_name;
    public $last_name;

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['id', 'status', 'type', 'created_at', 'updated_at', 'logged_at'], 'integer'],
            [['username', 'auth_key', 'password_hash', 'email', 'first_name', 'last_name'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = User::find();
        $query->joinWith('auditor');
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['defaultOrder' => ['id' => SORT_DESC]]
        ]);

        $loaded = $this->load($params);

        if ($this->status) {
            $query->andWhere([
                'status' => $this->status]);
        } else {
            $query->notDeleted();
        }

        if (!($loaded && $this->validate())) {
            return $dataProvider;
        }



        $query->andFilterWhere([
            'id' => $this->id,
            //'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'logged_at' => $this->logged_at,
            'type' => $this->type,
        ]);

        // $query->orderBy('id DESC');
        $query->andFilterWhere(['like', 'username', $this->username])
                ->andFilterWhere(['like', 'auditor.first_name', $this->first_name])
                ->andFilterWhere(['like', 'auditor.last_name', $this->last_name])
                ->andFilterWhere(['like', 'email', $this->email]);

        return $dataProvider;
    }

}
