<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\User */

$this->title = $model->getPublicIdentity();
$this->params['breadcrumbs'][] = ['label' => Yii::t('backend', 'Users'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-view">

    <p>
        <?php 
        if($model->id !=1)
        echo Html::a(Yii::t('backend', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) 
                
                ?>
       
    </p>

    <?php echo DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'username',
             ['label'=>'Assigned Votes',
                'value'=> $model->votesvalue 
            ],
             ['label'=>'Role(s)',
                'value'=> $model->rolesvalue
            ],
            'email:email',
            'status',
            'created_at:datetime',
            'updated_at:datetime',
            'logged_at:datetime',
             [
                'label' =>'Password',
                  'format' => 'raw',
                'value' => function($model) {
                      $expired = $model->expired?"<b style='color:red'>Expired </b>":"";
                    return $expired;
         },
            ],
           
        ],
    ]) ?>

</div>
